/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/14 15:15:16
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.Node;

/**
 * CAEg̈s\B
 * 
 * @version $Id: Row.java 379 2006-06-23 07:17:43Z nakajo $
 * @author Go Takahashi
 */
public class Row extends Box {
    
    public static final String NAME = "row";
    
//    protected Vector inlineElements = new Vector();
    private int maxWidth;
    private boolean _full;
    
    public Row(int maxWidth) {
        super(NAME);
        this.maxWidth = maxWidth;
    }
        
    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void applySelf(Form form) {
        _width = this.maxWidth;
        _height = getInheritedAttributeByInt("line-height", -1);
    }

    protected void applyChildren(Form form) {
        int x = 0;
        for (int i = 0; i < getChildCount(); ++i) {
            Inline inline = (Inline)getChildElement(i);
            //inline.apply(form);
            int boxHeight = inline.getBoxHeight();
            System.out.println(getClass().getName() + " box height=" + boxHeight);
            if (boxHeight > _height) {
                _height = boxHeight;
            }
        }
        for (int i = 0; i < getChildCount(); ++i) {
            Inline inline = (Inline)getChildElement(i);
            inline.setRelativePosition(x, inline.getLeading(getBoxHeight()) / 2);
            x += inline.getBoxWidth();
        }
    }
    
    /**
     * InlinẽTuNXR[܂B
     * @see jp.haw.grain.xforms.Row#append(jp.haw.grain.xforms.InlineElement)
     */
    public boolean addChildInline(Inline inline) {
    	System.out.println("Row: addChildInline(Inline inline) inline="+inline.getClass().getName());
        if (inline.getBoxWidth() < getRemainingWidth() || getChildCount() == 0) {
            addChild(inline);
            this._width += inline.getBoxWidth();
            return true;
        }
    	System.out.println("Row: false addChildInline(Inline inline)");
        return false;
    }

    public int getRemainingWidth() {
        int width = this._width < 0 ? 0 : this._width;
        System.out.println("Row: maxWidth="+maxWidth+": width="+width);
        return this.maxWidth - width;
    }
    
    public boolean isEmpty() {
        return getChildCount() == 0;
    }
        
    /* (non-Javadoc)
     * @see jp.haw.grain.xforms.Row#getChildElement(int)
     */
    public Inline getChildInline(int index) {
        return (Inline)_children.elementAt(index);
    }
    
    public void draw(DrawContext dc) {
        DrawContext childCtx = dc.createContext(getContentX(), getContentY());
        System.out.println("Row: _children="+_children);
        for (int i = 0; i < _children.size(); ++i) {
            Inline ie = (Inline)_children.elementAt(i);
            System.out.println("Row: ie="+ie);
            ie.draw(childCtx.moveTo(ie.x, ie.y));
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getText()
     */
    public String getText() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getChildText(int)
     */
    public String getChildText(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#preProcess(jp.grain.spike.Node)
     */
    public void preProcess(Node parent) {
        // nothing to do.
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#postProcess(jp.grain.spike.Node)
     */
    public void postProcess(Node parent) {
        // nothing to do.
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.Box#init()
     */
    public void init(Form form) {
        // nothing to do.
    }

    /* (non-Javadoc)
     * @see jp.grain.sprout.ui.Box#initChildren(jp.grain.sprout.ui.Form)
     */
    protected void initChildren(Form form) {
        // nothing to do.
    }
}
