/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/02/10 13:21:42
 * 
 */
package jp.grain.sprout;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Document;
import jp.grain.spike.Node;
import jp.grain.spike.xpath.XPathEvaluator;
import jp.grain.spike.xpath.XPathExpr;
import jp.grain.sprout.model.Bind;
import jp.grain.sprout.model.Model;
import jp.grain.sprout.ui.Form;

/**
 * TODO BindingElement
 * 
 * @version $Id$
 * @author nakajo
 */
public abstract class BindingElement extends DefaultElement {

	protected XPathExpr _bindingExpr;
	protected Node _contextNode;
	protected Node[] _bindingNodeset;
	protected Bind bind;

	public BindingElement(String name, String prefix, String namespace) {
		super(name, prefix, namespace);
	}

	public BindingElement(String name) {
		super(name);
	}

	public void init(Form form) {
		initAttribute(form);
		if (bind == null && _bindingExpr != null) {
			if (!_bindingExpr.needEvaluate()) return; // ČvZ̕Kv͂Ȃ̂ŏI

			System.out.println(getClass().getName() + ": init - binding expr");
			// 7.4-3-a: context model which 'model' atttibeute determines is
			// used
			Model contextModel = (Model) form.findNodeById(getAttribute("model"));
			if (contextModel != null) {
				form.pushContextModel(contextModel);
			}
			_contextNode = form.getContextNode();
			System.out.println("CONTEXT_NODE: " + _contextNode);

			XPathEvaluator.Result result = XPathEvaluator.evaluate(_contextNode, _bindingExpr);
			this._bindingNodeset = result.nodeset();

			form.pushContextNode(getBindingNode());
			System.out.println("INIT: form.pushContextNode(_bindingNodeset[0])");

			initChildren(form);

			form.popContextNode();
			if (contextModel != null) {
				form.popContextModel();
			}

		} else {
			initChildren(form);
		}

		System.out.println("INIT: bindingNode=" + getBindingNode());
	}

	abstract protected void initChildren(Form form);

	/**
	 * XPath̍ĕ]IɕKvƂƂɂ̃\bhĂяoĉB qɂAċĕ]ʒm܂B
	 * 
	 */
	public void requestEvaluate() {
		if (_bindingExpr != null) _bindingExpr.requestEvaluate();
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildElement(i) instanceof BindingElement) {
				((BindingElement) getChildElement(i)).requestEvaluate();
			}
		}
	}

	protected void initAttribute(Form form) {
		String bindId = getAttribute("bind");
		if (bindId == null) return;

		Node bind = form.findNodeById(bindId);
		if (bind == null || !(bind instanceof Bind)) {
			throw new RuntimeException("xforms-binding-exception: id=" + bindId);
		} else {
			this.bind = (Bind) bind;
		}
	}

	/*
	 * protected Instance findInstance(Form form) { Model ctxModel =
	 * form.getContextModel(getAttribute("model"));
	 * System.out.println("findinstance ctxmodel = " + (ctxModel == null));
	 * if(ctxModel == null) { //model݂Ȃ̂ō ctxModel = new Model();
	 * ctxModel.preProcess(form); } Instance ctxInstance =
	 * ctxModel.getInstance(); if(ctxInstance == null) {
	 * //instancêinstance ctxInstance = new Instance();
	 * ctxInstance.preProcess(ctxModel); }
	 * 
	 * return ctxInstance; }
	 */

	public boolean isBindingElement() {
		return _bindingExpr != null;
	}

	public Node getBindingNode() {
		if (getBindingNodeset().length == 0) return null;
		return getBindingNodeset()[0];
	}

	public Node[] getBindingNodeset() {
		if (bind != null) return bind.getBindingNodeset();

		if (_bindingExpr == null || _bindingNodeset == null) return new Node[0];
		return _bindingNodeset;
	}

	public void setBindingExpr(String name, XPathExpr binding) {
		_bindingExpr = binding;
		if (binding != null) binding.setParent(this);
	}

	public XPathExpr getBindingExpr() {
		return _bindingExpr;
	}

	public String getBindingSimpleContent() {
		if (getBindingNode() == null) return EMPTY_STRING;
		return getBindingNode().getSimpleContent();
	}

	public void setBindingSimpleContent(String content) {
		if (getBindingNode() == null) return;
		getBindingNode().setSimpleContent(content);
	}

	public Node clone(Document doc) {
		BindingElement node = (BindingElement) super.clone(doc);
		if (this._bindingExpr != null) node.setBindingExpr(this._bindingExpr.getAttribute("name"), this._bindingExpr);
		return node;
	}

}
