package jp.grain.sprout.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EmptyStackException;

import jp.grain.spike.Document;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.spike.event.EventListener;
import jp.grain.spike.xpath.XPathEvaluator;
import jp.grain.spike.xpath.XPathExpr;
import jp.grain.sprout.BindingElement;
import jp.grain.sprout.DataHandler;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.model.Model;
import jp.grain.sprout.model.Submission;
import jp.grain.sprout.platform.doja.DataLoadOperation;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.InlineComponent;

public class Action extends BindingElement implements EventListener, DataHandler {

	public static final String NAME = "action";

	/** ANVvf */
	public static final String ACTION_ACTION = "action";
	public static final String ACTION_DISPATCH = "dispatch";
	public static final String ACTION_REBUILD = "rebuild";
	public static final String ACTION_RECALCULATE = "recalculate";
	public static final String ACTION_REVALIDATE = "revalidate";
	public static final String ACTION_REFRESH = "refresh";
	public static final String ACTION_SETFOCUS = "setfocus";
	public static final String ACTION_LOAD = "load";
	public static final String ACTION_SETVALUE = "setvalue";
	public static final String ACTION_SEND = "send";
	public static final String ACTION_RESET = "reset";
	public static final String ACTION_MESSAGE = "message";

	public static final String ACTION_INSERT = "insert";
	public static final String ACTION_DELETE = "delete";
	public static final String ACTION_SETINDEX = "setindex";

	// x̂߂̃tO
	// 10.1.1 actionvf
	// xXVF XFormsANV̒ɂ́Cactionvf̎qvfƂĎw肳ꂽꍇɁC
	// CX^Xf[^ɑ΂ĒxēKpʂ̂B
	// 
	// ł́CxXV̂ɂǂ̂悤ȕ@̗pĂ悢C
	// ʂ͒߂ꂽƂɂȂȂ΂ȂȂB܂CÃANVɂăCX^Xf[^ύXꂽC
	// łÕANVnh̏I܂ŁCvZɕKvȈˑ֌W̍č\zCČvZCÓ̍Č؋y
	// tH[̃tbV͍sĂ͂ȂȂBłOɂeANVnh́C
	// ̃ANVnh̏IrebuildCrecalculateCrevalidateyrefresh̃ANVKvł邩ǂC
	// lfalseł_ltOƍl邱ƂłB
	private boolean _rebuild;
	private boolean _recalculate;
	private boolean _revalidate;
	private boolean _refresh;

	private XPathExpr _optionalExpr;

	private String _outerMessage;
	private Model _contextModel;

	/**
	 * @param name
	 */
	public Action() {
		super(NAME);
	}

	public boolean isHandlableEvent(String eventType) {
		String ev = getAttribute("event", Event.NAME_SPACE);
		System.out.println("Action: ev=" + ev + ": eventType=" + eventType);
		return eventType.equals(ev);
	}

	public boolean dispatchEvent(Event event) {
		return handleEvent(event);
	}

	public String[] getHandleEvents() {
		// TODO ꂽ\bhEX^u
		return new String[0];
	}

	public boolean handleEvent(Event event) {
		Form form = (Form) getDocument();
		// Actionvfł̓CxghandlingƂɏ߂XPath]
		evaluate(form);

		System.out.println("Action: handleEvent name=" + getAttribute("name"));
		if (ACTION_ACTION.equals(getAttribute("name"))) {
			// Cxgɂ͒x̂߂̊etO
			this._rebuild = false;
			this._recalculate = false;
			this._revalidate = false;
			this._refresh = false;

			System.out.println("Action: handleEvent child=" + getChildCount());
			for (int i = 0; i < getChildCount(); i++) {
				System.out.println("Action child[" + i + "]=" + getChild(i).getClass().getName());
				Action action = (Action) getChildElement(i);
				if (action == null) continue;
				action.handleEvent(event);
			}

			// qvf̃CxgIetȌԂ݂ĕKvȃCxgʒmĂ
			Event delayEvent = new Event(Event.TYPE_XFORMS_REBUILD, this, event, null, true, true);
			System.out.println("Action: model=" + _contextModel);
			if (this._rebuild) {
				if (_contextModel != null) {
					_contextModel.handleEvent(delayEvent);
				} else {
					form.getModel(0).handleEvent(delayEvent);
				}
			}
			if (this._recalculate) {
				delayEvent.setType(Event.TYPE_XFORMS_RECALCULATE);
				if (_contextModel != null) {
					_contextModel.handleEvent(delayEvent);
				} else {
					form.getModel(0).handleEvent(delayEvent);
				}
			}
			if (this._revalidate) {
				delayEvent.setType(Event.TYPE_XFORMS_REVALIDATE);
				if (_contextModel != null) {
					_contextModel.handleEvent(delayEvent);
				} else {
					form.getModel(0).handleEvent(delayEvent);
				}
			}
			if (this._refresh) {
				delayEvent.setType(Event.TYPE_XFORMS_REFRESH);
				if (_contextModel != null) {
					_contextModel.handleEvent(delayEvent);
				} else {
					form.getModel(0).handleEvent(delayEvent);
				}
			}
		} else if (ACTION_SEND.equals(getAttribute("name"))) {
			String id = getAttribute("submission");
			System.out.println("submission id = " + id);
			if (id == null) return false;
			System.out.println("form  = " + form);
			Node node = form.findNodeById(id);
			System.out.println("find element = " + node != null ? node.getClass().getName() : null);
			if (node != null && node instanceof Submission) {
				((Submission) node).submit(form.getContext());
			}

			return false;
		} else if (ACTION_DISPATCH.equals(getAttribute("name"))) {
			Event dispatch = new Event(getAttribute("eventtype"), this, event);
			EventListener listener = (EventListener) form.findNodeById(getAttribute("target"));
			listener.handleEvent(dispatch);
		} else if (ACTION_REBUILD.equals(getAttribute("name"))) {
			Event ev = new Event(Event.TYPE_XFORMS_REBUILD, this, event, null, true, true);
			if (getAttribute("model") != null) {
				form.getContextModel(getAttribute("model")).handleEvent(ev);
			} else {
				form.getContextModel(null).handleEvent(ev);
			}
			((Action) _parent)._rebuild = false;
		} else if (ACTION_RECALCULATE.equals(getAttribute("name"))) {
			Event ev = new Event(Event.TYPE_XFORMS_RECALCULATE, this, event, null, true, true);
			if (getAttribute("model") != null) {
				form.getContextModel(getAttribute("model")).handleEvent(ev);
			} else {
				form.getContextModel(null).handleEvent(ev);
			}
			((Action) _parent)._recalculate = false;
		} else if (ACTION_REVALIDATE.equals(getAttribute("name"))) {
			Event ev = new Event(Event.TYPE_XFORMS_REVALIDATE, this, event, null, true, true);
			if (getAttribute("model") != null) {
				form.getContextModel(getAttribute("model")).handleEvent(ev);
			} else {
				form.getContextModel(null).handleEvent(ev);
			}
			((Action) _parent)._revalidate = false;
		} else if (ACTION_REFRESH.equals(getAttribute("name"))) {
			Event ev = new Event(Event.TYPE_XFORMS_REFRESH, this, event, null, true, true);
			if (getAttribute("model") != null) {
				form.getContextModel(getAttribute("model")).handleEvent(ev);
			} else {
				form.getContextModel(null).handleEvent(ev);
			}
			((Action) _parent)._refresh = false;
		} else if (ACTION_SETFOCUS.equals(getAttribute("name"))) {
			Event focusEvent = new Event(Event.TYPE_XFORMS_FOCUS, this, event, getAttribute("control"), false, true);
			form.notifyEvent(focusEvent);
		} else if (ACTION_LOAD.equals(getAttribute("name"))) {
			// TODO: showɉU镑̕ύX͂ǂ悤HH
			SerializeOperation ope = form.getContext().createSubmissionOperation(getAttribute("resource"));
			form.getContext().execute(ope);
		} else if (ACTION_SETVALUE.equals(getAttribute("name"))) {
			if (this.bind != null) {
				bind.init(form);
			}

			if (getBindingNode() == null) return false;

			String newValue = null;
			if (this._optionalExpr != null) {
				newValue = XPathEvaluator.evaluate(getBindingNode(), _optionalExpr).string();
			} else if (getSimpleContent() != null) {
				newValue = getSimpleContent();
			} else {
				newValue = "";
			}
			System.out.println("Action: ACTION_SETVALUE getBindingNode()=" + getBindingNode());
			System.out.println("Action: ACTION_SETVALUE newValue=" + newValue);

			Node bindingNode = getBindingNode();
			bindingNode.setSimpleContent(newValue);

			System.out.println("Action: _parent=" + _parent.getClass().getName());
			((Action) _parent)._recalculate = true;
			((Action) _parent)._revalidate = true;
			((Action) _parent)._refresh = true;
			if (_contextModel != null) {
				((Action) _parent)._contextModel = _contextModel;
			}
		} else if (ACTION_RESET.equals(getAttribute("name"))) {
			Event ev = new Event(Event.TYPE_XFORMS_RESET, this, event, null, true, true);
			if (getAttribute("model") != null) {
				form.getContextModel(getAttribute("model")).handleEvent(ev);
			} else {
				form.getContextModel(null).handleEvent(ev);
			}
			((Action) _parent)._rebuild = false;
			((Action) _parent)._recalculate = false;
			((Action) _parent)._revalidate = false;
			((Action) _parent)._refresh = false;
		} else if (ACTION_MESSAGE.equals(getAttribute("name"))) {
			// TODO: levelɉăbZ[W{bNXύXB
			String msg = null;
			if (getAttribute("src") != null) {
				SerializeOperation ope = new DataLoadOperation(getAttribute("src"), this);
				form.getContext().execute(ope);
				msg = this._outerMessage;
			} else {
				msg = getSimpleContent();
			}
			form.getContext().showMessageDialog(msg);
		} else if (ACTION_INSERT.equals(getAttribute("name"))) {
			System.out.println("Action: ACTION_INSERT _bindingNodeset=" + _bindingNodeset.length);
			Node last = _bindingNodeset[_bindingNodeset.length - 1];
			Node copy = last.clone(last.getDocument());
			System.out.println("Action: ACTION_INSERT last=" + last + "@" + last.hashCode());
			System.out.println("Action: ACTION_INSERT copy=" + copy + "@" + copy.hashCode());
			Integer o_index = XPathEvaluator.evaluate(_contextNode, _optionalExpr).number();
			System.out.println("Action: ACTION_INSERT at=" + o_index);
			int index = 0;

			if (o_index == null) {
				// 9.3.5-2.b
				index = _bindingNodeset.length + 1;
			} else {
				index = o_index.intValue();
			}

			System.out.println("Action: ACTION_INSERT index=" + index);

			if (index < 0) {
				Element parent = (Element) _bindingNodeset[0].getParent();
				parent.addChild(0, copy);
			} else if (index >= (_bindingNodeset.length - 1)) {
				Element parent = (Element) last.getParent();
				parent.addChild(copy);
				System.out.println("Action: ACTION_INSERT addChild(copy)");
			} else {
				Element parent = (Element) _bindingNodeset[index].getParent();
				int realIndex = parent.getChildren().indexOf(_bindingNodeset[index]);
				if ("before".equals(getAttribute("position"))) {
					parent.addChild(realIndex, copy);
					System.out.println("Action: ACTION_INSERT addChildBefore(copy)");
				} else if ("after".equals(getAttribute("position"))) {
					parent.addChild(realIndex + 1, copy);
					System.out.println("Action: ACTION_INSERT addChildAfter(copy)");
				}
			}

			// TODO: 9.3.5 3, 4 no implementation

			((Action) _parent)._rebuild = true;
			((Action) _parent)._recalculate = true;
			((Action) _parent)._revalidate = true;
			((Action) _parent)._refresh = true;
			if (_contextModel != null) {
				((Action) _parent)._contextModel = _contextModel;
			}

		} else if (ACTION_DELETE.equals(getAttribute("name"))) {
			Integer o_index = XPathEvaluator.evaluate(_contextNode, _optionalExpr).number();
			System.out.println("Action: ACTION_DELETE at=" + o_index);
			// 9.3.6-2
			if (o_index == null) return false;
			int index = o_index.intValue() - 1; // repeat index
			// 1n܂̂offsetKv
			if (index < 0 || index > (_bindingNodeset.length - 1)) return false;

			Node target = _bindingNodeset[index];
			Element parent = (Element) target.getParent();
			parent.removeChild(target);

			((Action) _parent)._rebuild = true;
			((Action) _parent)._recalculate = true;
			((Action) _parent)._revalidate = true;
			((Action) _parent)._refresh = true;
			if (_contextModel != null) {
				((Action) _parent)._contextModel = _contextModel;
			}
		} else if (ACTION_SETINDEX.equals(getAttribute("name"))) {
			// TODO: no implementation reson why the repeat element not have
			// index.
		}

		return false;
	}

	private void evaluate(Form form) {
		initAttribute(form);
		if (bind == null && _bindingExpr != null) {
			if (!_bindingExpr.needEvaluate()) return; // ČvZ̕Kv͂Ȃ̂ŏI

			System.out.println(getClass().getName() + ": init - binding expr");
			// 7.4-3-a: context model which 'model' atttibeute determines is
			// used
			Model contextModel = null;
			if(_contextModel != null) {
				//initcontextModel擾Ă炻g
				contextModel = _contextModel;
			} else {
				// initŎĂȂR|[lgActionł͂Ȃ̂Œʏʂ̏łnj
				contextModel = (Model) form.findNodeById(getAttribute("model"));
			}

			if (contextModel != null) {
				form.pushContextModel(contextModel);
			}

			_contextNode = form.getContextNode();
			System.out.println("CONTEXT_NODE: " + _contextNode);

			XPathEvaluator.Result result = XPathEvaluator.evaluate(_contextNode, _bindingExpr);
			this._bindingNodeset = result.nodeset();

			form.pushContextNode(getBindingNode());
			System.out.println("INIT: form.pushContextNode(_bindingNodeset[0])");

			evaluateChildren(form);
			form.popContextNode();
			if (contextModel != null) {
				form.popContextModel();
			}

		} else {
			evaluateChildren(form);
		}

		System.out.println("INIT: bindingNode=" + getBindingNode());
	}

	private void evaluateChildren(Form form) {
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildElement(i) == null) continue;
			((Action) getChildElement(i)).evaluate(form);
		}
	}

	public void init(Form form) {
		// Actioninit͓Ȃ̂ɂȂB
		// Actionł̓Cxg^C~OXPath]̂
		// łcontextModelcontextNode̎擾݂̂sB
		if (bind == null && _bindingExpr != null) {
			System.out.println(getClass().getName() + ": init - binding expr");
			// 7.4-3-a: context model which 'model' atttibeute determines is
			// used
			Model contextModel = (Model) form.findNodeById(getAttribute("model"));
			if (contextModel != null) {
				this._contextModel = contextModel;
				// ̌qinitCxg͍sȂ̂pushKv͂ȂB
				// form.pushContextModel(contextModel);
			} else {
				// econtextModelςĂ邩Ȃ̂ł擾
				try {
					// 悸popĂ݂BemptyException
					// ꂽ猳ɖ߂Ă
					this._contextModel = form.popContextModel();
					form.pushContextModel(this._contextModel);
				} catch (EmptyStackException e) {
					// X^bN͋ۂȂ̂Ő擪model擾
					this._contextModel = form.getModel(0);
				}
			}
			System.out.println(getClass().getName() + ":CTXMODEL: name=" + getAttribute("name") + " model_id=" + _contextModel.getAttribute("id"));
			System.out.println("INIT: bindingNode=" + getBindingNode());
		} else {
			initChildren(form);
		}

	}

	protected void initChildren(Form form) {
		for (int i = 0; i < getChildCount(); i++) {
			if (getChildElement(i) == null) continue;
			((Action) getChildElement(i)).init(form);
		}
	}

	public void preProcess(Node parent) {
		if (parent instanceof InlineComponent) {
			((InlineComponent) parent).addAction(this);
		} else if (parent instanceof Model) {
			Model model = (Model) parent;
			model.addChild(this);
		} else if (parent instanceof Submission) {
			Submission submission = (Submission) parent;
			submission.addChild(this);
		} else if (parent instanceof Action) {
			Action action = (Action) parent;
			action.addChild(this);
		}
	}

	public void postProcess(Node parent) {
	}

	public void setBindingExpr(String name, XPathExpr binding) {
		if ("ref".equals(name) || "nodeset".equals(name)) {
			this._bindingExpr = binding;
		} else {
			this._optionalExpr = binding;
		}
		if (binding != null) binding.setParent(this);
	}

	public void handleInputStream(InputStream is) throws IOException {
		byte[] buf = new byte[1024];
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		int size = 0;
		while ((size = is.read(buf)) != -1) {
			out.write(buf, 0, size);
		}

		this._outerMessage = new String(out.toByteArray());
	}

	public Node clone(Document doc) {
		Action clone = (Action) super.clone(doc);
		if (_optionalExpr != null) {
			clone.setBindingExpr(_optionalExpr.getAttribute("name"), _optionalExpr);
		}

		return clone;
	}

	protected Element createElement() {
		return new Action();
	}

}
