/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/04/08 23:48:47
 * 
 */
package jp.grain.sprout.action;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.spike.event.EventListener;
import jp.grain.sprout.model.Submission;
import jp.grain.sprout.ui.Button;
import jp.grain.sprout.ui.Form;

/**
 * TODO SendAction
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Send extends DefaultElement implements EventListener {
    
    public static final String NAME = "send";
    /**
     * @param name
     */
    public Send() {
        super(NAME);
    }

    public boolean isHandlableEvent(String eventType) {
    	String ev = getAttribute("event", Event.NAME_SPACE);
    	return eventType.equals(ev);
    }
    
    public boolean dispatchEvent(Event event) {
    	return handleEvent(event);
	}

	public String[] getHandleEvents() {
		// TODO ꂽ\bhEX^u
		return new String[0];
	}

	public boolean handleEvent(Event event) {
        String id = getAttribute("submission");
        System.out.println("submission id = " + id);
        if (id == null) return false;
        Form form = (Form)getDocument();
        System.out.println("form  = " + form);
        Node node = form.findNodeById(id);
        System.out.println("find element = " + node != null ? node.getClass().getName() : null);
        if (node != null && node instanceof Submission) {
            ((Submission)node).submit(form.getContext());
        }
        
        return false;
    }

	public void postProcess(Node parent) {
		if(parent instanceof Button) {
			//((Button)parent).addAction(this);
		}
	}
	
}
