package jp.grain.sprout.platform.doja;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

import java.io.IOException;
import java.io.InputStream;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;

import jp.grain.spike.BinaryXMLParser;
import jp.grain.spike.Document;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.InstanceElement;
import jp.grain.sprout.model.Submission;
import jp.grain.sprout.ui.Choice;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;
import jp.grain.sprout.ui.Itemset;
import jp.grain.sprout.ui.Select;

import org.xmlpull.v1.XmlPullParserException;

public class ItemsetTest extends TestCase {

    private Form form;
    
    public ItemsetTest() {
    }

    public ItemsetTest(String name, TestMethod method) {
        super(name, method);
    }

    protected void setUp() throws Exception {
        // gbxml rev 154 06/02/02
        MockSproutApp app = new MockSproutApp("resource:///itemset_test.gbxml");
        app.start();
        
        FormContextImpl ctx = (FormContextImpl) app.getFormContext();
        ctx.getInitializer().join();
        form = ctx.getForm();
    }

    public void testInitSelected() {
    	Choice icec = (Choice)form.findNodeById("ice_choice");
    	Select ices = (Select)form.findNodeById("ice_select");
    	Itemset choice_itemset = (Itemset)icec.getChildNode(0);
    	Itemset select_itemset = (Itemset)ices.getChildNode(0);
    	
        assertEquals("choice init selected check", "true", String.valueOf(choice_itemset.getItemAt(0).isSelected()));
        assertEquals("select init selected check1", "true", String.valueOf(select_itemset.getItemAt(0).isSelected()));
        assertEquals("select init selected check2", "true", String.valueOf(select_itemset.getItemAt(1).isSelected()));

        assertEquals("choice init not selected check1", "false", String.valueOf(choice_itemset.getItemAt(1).isSelected()));
        assertEquals("choice init not selected check2", "false", String.valueOf(choice_itemset.getItemAt(2).isSelected()));
        assertEquals("select init not selected check", "false", String.valueOf(select_itemset.getItemAt(2).isSelected()));
        
        
    }

    public void testCopyProcess() {
    	Choice icec = (Choice)form.findNodeById("ice_choice");
    	Select ices = (Select)form.findNodeById("ice_select");
    	Itemset choice_itemset = (Itemset)icec.getChildNode(0);
    	Itemset select_itemset = (Itemset)ices.getChildNode(0);
    	InstanceElement checkIN = icec.getBindingInstanceElement();
    	InstanceElement selectIN = ices.getBindingInstanceElement();
    	

        assertEquals("choice instance node simpleContent check", "strobery", checkIN.getSimpleContent());
        assertEquals("choice instance node copyNode check", 1, checkIN.getChildCount());

        assertEquals("select instance node simpleContent check", "strobery melon", selectIN.getSimpleContent());
        assertEquals("select instance node copyNode check", 1, selectIN.getChildCount());
        
    	choice_itemset.commitValue(checkIN);
    	select_itemset.commitValue(selectIN);

    	//simpleContentƃRs[ꂽm[h
        assertEquals("choice instance node copyNode check", 2, checkIN.getChildCount());
        //simpleContentƃRs[ꂽm[h2
        assertEquals("select instance node copyNode check", 3, selectIN.getChildCount());
    	
    }

    public void testReSelectedCopyProcess() {
    	Choice icec = (Choice)form.findNodeById("ice_choice");
    	Select ices = (Select)form.findNodeById("ice_select");
    	Itemset choice_itemset = (Itemset)icec.getChildNode(0);
    	Itemset select_itemset = (Itemset)ices.getChildNode(0);
    	InstanceElement checkIN = icec.getBindingInstanceElement();
    	InstanceElement selectIN = ices.getBindingInstanceElement();
    	
    	choice_itemset.commitValue(checkIN);
    	select_itemset.commitValue(selectIN);

    	//simpleContentƃRs[ꂽm[h
        assertEquals("choice instance node copyNode check", 2, checkIN.getChildCount());
        assertEquals("choice instance node copyNode value check", "strobery", ((InstanceElement)checkIN.getChild(1)).getSimpleContent());
        //simpleContentƃRs[ꂽm[h2
        assertEquals("select instance node copyNode check", 3, selectIN.getChildCount());
    	
        choice_itemset.DeselectAll();
        select_itemset.DeselectAll();
        
        choice_itemset.getItemAt(2).setSelected(true);
        select_itemset.getItemAt(2).setSelected(true);
    	choice_itemset.commitValue(checkIN);
    	select_itemset.commitValue(selectIN);

    	//simpleContentƃRs[ꂽm[h
        assertEquals("choice recopy node check", 2, checkIN.getChildCount());
        assertEquals("choice recopy node value check", "vanira", ((InstanceElement)checkIN.getChild(1)).getSimpleContent());
        //simpleContentƃRs[ꂽm[h2
        assertEquals("select recopy node check", 2, selectIN.getChildCount());

        choice_itemset.DeselectAll();
        select_itemset.DeselectAll();
        
        choice_itemset.getItemAt(1).setSelected(true);
        select_itemset.getItemAt(0).setSelected(true);
        select_itemset.getItemAt(1).setSelected(true);
        select_itemset.getItemAt(2).setSelected(true);
    	choice_itemset.commitValue(checkIN);
    	select_itemset.commitValue(selectIN);

    	//simpleContentƃRs[ꂽm[h
        assertEquals("choice recopy node check", 2, checkIN.getChildCount());
        assertEquals("choice recopy node value check", "melon", ((InstanceElement)checkIN.getChild(1)).getSimpleContent());
        //simpleContentƃRs[ꂽm[h2
        assertEquals("select recopy node check", 4, selectIN.getChildCount());
    	
    }

    public Test suite() {
        TestSuite suite = new TestSuite();

        suite.addTest(new ItemsetTest("testInitSelected", new TestMethod() {
            public void run(TestCase tc) { ((ItemsetTest)tc).testInitSelected(); }
        }));

        suite.addTest(new ItemsetTest("testCopyProcess", new TestMethod() {
            public void run(TestCase tc) { ((ItemsetTest)tc).testCopyProcess(); }
        }));

        suite.addTest(new ItemsetTest("testReSelectedCopyProcess", new TestMethod() {
            public void run(TestCase tc) { ((ItemsetTest)tc).testReSelectedCopyProcess(); }
        }));

        return suite;
    }

    /**
     * Mock Classes 
     */
    class MockSproutApp extends GrainApp {

        Throwable error;
        String defaultUri;
        
        MockSproutApp(String defaultUri) {
            setDefaultFormUrl(defaultUri);
            setDefaultFormLocation(DEFAULT_FORM_LOC_HTTP);
            _context = new MockFormContextImpl(this);
        }
        
        public void loadBasicPref() {
        }
        
        public FormContext getFormContext() {
            return _context;
        }
    }
    
    class MockFormContextImpl extends FormContextImpl {

        MockFormContextImpl(GrainApp app) {
            super(app);
        }
                
        public SerializeOperation createSubmissionOperation(String url) {
            return new MockSubmissionOperation(url, this);
        }

        public SerializeOperation createSubmissionOperation(Submission element) {
            if (element == null) {
                return new MockSubmissionOperation(_app.getDefaultFormUrl(), this);
            } else {
                Form f = (Form)element.getDocument();
                return new MockSubmissionOperation(f.createCanonicalUrl(element.getActionUrl()), this);
            }
        }
        
        public SerializeOperation createExternalInstanceLoadOperation(Instance element) {
            return super.createExternalInstanceLoadOperation(element);
        }
    }
    
    class MockSubmissionOperation extends SerializeOperation {

        private String url;
        private Form form;
        private Initializer initializer;
        
        MockSubmissionOperation(String url, FormContext context) {
            this.url = url;
            this.initializer = new Initializer(context);
        }

        public String getConnectionString() {
            return this.url;
        }

        public int getMode() {
            return Connector.READ;
        }

        public Document getInstanceDocument() {
            return null;
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.FormSerializeOperation#setListener(jp.grain.sprout.OperetionListener)
         */
        public void setListener(OperetionListener observer) {
            // TODO Auto-generated method stub
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doExecute(javax.microedition.io.Connection)
         */
        protected void doExecute(Connection conn) throws Exception {
            InputStream is = null;
            try {
                is = ((InputConnection)conn).openInputStream();
                BinaryXMLParser parser = BinaryXMLParser.newInstance(is, "SJIS");
                FormBuilder builder = new FormBuilder(parser, getConnectionString(), true);
                builder.build();
                this.form = (Form)builder.getDocument();
            } catch (IOException e) {
                e.printStackTrace();
                throw e;
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } finally {
                if (is != null) is.close();
            }
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doCompletion()
         */
        protected void doCompletion() throws Exception {
            this.initializer.init(this.form);
            this.initializer.start();
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
         */
        protected void doException(Exception e) {
            // TODO Auto-generated method stub
            
        }
    }
}
