/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.GudTransformException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GudConverter {
    private static final Logger log = Logger.getLogger(GudConverter.class);
    private InputSource source;
    private String encoding = "Shift_JIS";
    private DocumentBuilderFactory factory;

    public GudConverter(byte[] bs) {
        try {
            String header = new String(bs, 0, bs.length > 50 ? 50 : bs.length, "ISO-8859-1");
            this.parseEncoding(header);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.source = new InputSource(new ByteArrayInputStream(bs));
    }

    public GudConverter(char[] cs) {
        this.source = new InputSource(new CharArrayReader(cs));
        String head = new String(cs, 0, cs.length > 50 ? 50 : cs.length);
        this.parseEncoding(head);
    }

    public GudConverter(InputStream is) {
        this.source = new InputSource(is);
    }

    public GudConverter(Reader reader) {
        this.source = new InputSource(reader);
    }

    public GudConverter(String src) {
        this.source = new InputSource(new StringReader(src));
        this.parseEncoding(src);
    }

    private void parseEncoding(String head) {
        if (!head.startsWith("<?xml")) {
            return;
        }
        Matcher m = Pattern.compile("encoding=\"([^\"]*)\"").matcher(head);
        if (m.find() && m.groupCount() > 0) {
            this.setTextEncoding(m.group(1));
        }
    }

    public void setTextEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory factory) {
        this.factory = factory;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.factory == null) {
            this.factory = DocumentBuilderFactoryImpl.newInstance();
            this.factory.setNamespaceAware(true);
            this.factory.setIgnoringElementContentWhitespace(true);
            this.factory.setIgnoringComments(true);
            this.factory.setCoalescing(true);
        }
        return this.factory;
    }

    public String convert() throws ParserConfigurationException, GudTransformException, IOException, SAXException {
        DocumentBuilder builder = this.getDocumentBuilderFactory().newDocumentBuilder();
        Document doc = builder.parse(this.source);
        GudBuilder gudbuilder = new GudBuilder(doc);
        Document gudDoc = gudbuilder.build();
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = this.getSerializer(writer);
        serializer.serialize(gudDoc);
        return writer.toString();
    }

    private XMLSerializer getSerializer(Writer out) {
        OutputFormat formatter = new OutputFormat();
        formatter.setPreserveSpace(true);
        formatter.setIndenting(false);
        formatter.setOmitXMLDeclaration(false);
        formatter.setEncoding(this.encoding);
        XMLSerializer serializer = new XMLSerializer(out, formatter);
        return serializer;
    }
}

