/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.xpath;

import java.util.Set;
import java.util.TreeSet;
import jp.haw.grain.dom.ElementWrapper;
import jp.haw.grain.xpath.XPathByteCodeElementInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XPathByteCodeElement
extends ElementWrapper
implements XPathByteCodeElementInterface {
    public static final int CONTEXT_PARAM_SIZE = 0;
    public static final int CONTEXT_PARAM_POSITION = 1;
    public static final String XPATH_EXPR_ROOT_NODE_NAME = "xpath:expr";
    public static final String AXIS_ABSOLUTE = "absolute";
    public static final String AXIS_SELF = "self";
    public static final String AXIS_CHILD = "child";
    public static final String AXIS_PARENT = "parent";
    public static final String AXIS_ANCESTOR = "ancestor";
    public static final String AXIS_FOLLOWING = "following";
    public static final String AXIS_PRECEDING = "preceding";
    public static final String AXIS_ATTRIBUTE = "attribute";
    public static final String AXIS_NAMESPACE = "namespace";
    public static final String AXIS_DESCENDANT = "descendant";
    public static final String AXIS_ANCESTOR_OR_SELF = "ancestor-or-self";
    public static final String AXIS_DESCENDANT_OR_SELF = "descendant-or-self";
    public static final String AXIS_FOLLOWING_SIBLING = "following-sibling";
    public static final String AXIS_PRECEDING_SIBLING = "preceding-sibling";
    public static final Set AXIS_MAP = new TreeSet();
    public static final String OP_SPUSH = "spush";
    public static final String OP_CLSPUSH = "clspush";
    public static final String OP_CTXNLOAD = "ctxnload";
    public static final String OP_CTXPLOAD = "ctxpload";
    public static final String OP_STEP = "step";
    public static final String OP_FILTER = "filter";
    public static final String OP_NFILTER = "nfilter";
    public static final String OP_FCALL = "fcall";
    public static final String OP_ADD = "add";
    public static final String OP_SUB = "sub";
    public static final String OP_DIV = "div";
    public static final String OP_MUL = "mul";
    public static final String OP_MOD = "mod";
    public static final String OP_NEG = "neg";
    public static final String OP_EQ = "eq";
    public static final String OP_NE = "ne";
    public static final String OP_LT = "lt";
    public static final String OP_LE = "le";
    public static final String OP_GT = "gt";
    public static final String OP_GE = "ge";
    public static final String OP_AND = "and";
    public static final String OP_OR = "or";
    public static final String FUNC_POSITION = "position";
    public static final String FUNC_LAST = "last";
    public static final String FUNC_NUMBER = "number";
    public static final String FUNC_STRING = "string";
    public static final String FUNC_BOOLEAN = "boolean";
    public static final String FUNC_COUNT = "count";
    public static final String FUNC_ID = "id";
    public static final String FUNC_CONCAT = "concat";
    public static final String FUNC_STARTS_WITH = "starts-with";
    public static final String FUNC_CONTAINS = "contains";
    public static final String FUNC_SUBSTRING_BEFORE = "substring-before";
    public static final String FUNC_SUBSTRING_AFTER = "substring-after";
    public static final String FUNC_SUBSTRING = "substring";
    public static final String FUNC_STRING_LENGTH = "string-length";
    public static final String FUNC_NORMALIZE_SPACE = "normalize-space";
    public static final String FUNC_TRANSLATE = "translate";
    protected int type;

    public static XPathByteCodeElement createStringValueElement(String str, Document doc) {
        XPathByteCodeElement stringElement = XPathByteCodeElement.createValueElement(OP_SPUSH, doc);
        stringElement.setAttribute("_0", str);
        return stringElement;
    }

    public static XPathByteCodeElement createNumValueElement(int num, Document doc) {
        String str = "N" + String.valueOf(num);
        return XPathByteCodeElement.createValueElement(str, doc);
    }

    public static XPathByteCodeElement createBooleanValueElement(boolean bool, Document doc) {
        String str = String.valueOf(bool);
        return XPathByteCodeElement.createValueElement(str, doc);
    }

    public static XPathByteCodeElement createPredicateElement(Document doc) {
        return XPathByteCodeElement.createClosureElement(OP_CLSPUSH, doc);
    }

    public static XPathByteCodeElement createAxisElement(String axis, Document doc) {
        if (!AXIS_MAP.contains(axis)) {
            throw new RuntimeException("Wrong axis name! :[" + axis + "]");
        }
        String str = "_" + axis;
        return XPathByteCodeElement.createValueElement(str, doc);
    }

    public static XPathByteCodeElement createStepElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_STEP, doc);
    }

    public static XPathByteCodeElement createContextLoadElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_CTXNLOAD, doc);
    }

    public static XPathByteCodeElement createContextParamLoadElement(int index, Document doc) {
        if (index < 0 || index > 2) {
            throw new RuntimeException("Wrong index!. indexi is 0 or 1: [" + index + "]");
        }
        XPathByteCodeElement ctxpload = XPathByteCodeElement.createExprElement(OP_CTXPLOAD, doc);
        ctxpload.setAttribute("_0", String.valueOf(index));
        return ctxpload;
    }

    public static XPathByteCodeElement createFilterElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_FILTER, doc);
    }

    public static XPathByteCodeElement createNFilterElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_NFILTER, doc);
    }

    public static XPathByteCodeElement createFcallElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_FCALL, doc);
    }

    public static XPathByteCodeElement createUnionElement(Document doc) {
        return XPathByteCodeElement.createExprElement("union", doc);
    }

    public static XPathByteCodeElement createAndElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_AND, doc);
    }

    public static XPathByteCodeElement createOrElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_OR, doc);
    }

    public static XPathByteCodeElement createEqElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_EQ, doc);
    }

    public static XPathByteCodeElement createNeElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_NE, doc);
    }

    public static XPathByteCodeElement createLtElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_LT, doc);
    }

    public static XPathByteCodeElement createLeElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_LE, doc);
    }

    public static XPathByteCodeElement createGtElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_GT, doc);
    }

    public static XPathByteCodeElement createGeElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_GE, doc);
    }

    public static XPathByteCodeElement createAddElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_ADD, doc);
    }

    public static XPathByteCodeElement createSubElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_SUB, doc);
    }

    public static XPathByteCodeElement createDivElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_DIV, doc);
    }

    public static XPathByteCodeElement createMultElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_MUL, doc);
    }

    public static XPathByteCodeElement createModElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_MOD, doc);
    }

    public static XPathByteCodeElement createNegElement(Document doc) {
        return XPathByteCodeElement.createExprElement(OP_NEG, doc);
    }

    private static XPathByteCodeElement createValueElement(String name, Document doc) {
        return new XPathByteCodeElement(doc.createElementNS("http://grain.jp/xpath/", "xpath:" + name), 0);
    }

    private static XPathByteCodeElement createExprElement(String name, Document doc) {
        return new XPathByteCodeElement(doc.createElementNS("http://grain.jp/xpath/", "xpath:" + name), 1);
    }

    private static XPathByteCodeElement createClosureElement(String name, Document doc) {
        return new XPathByteCodeElement(doc.createElementNS("http://grain.jp/xpath/", "xpath:" + name), 2);
    }

    private XPathByteCodeElement(Element e, int elementType) {
        super(e);
        this.type = elementType;
    }

    public int getByteCodeType() {
        return this.type;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[" + this.node.getNodeName() + ": " + this.node.getNodeValue() + "]");
        if (this.node.hasAttributes()) {
            str.append("attrs[");
            NamedNodeMap attrs = this.node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (i > 0) {
                    str.append(": ");
                }
                str.append(attr.getNodeName() + "=" + attr.getNodeValue());
            }
            str.append("]");
        }
        return str.toString();
    }

    static {
        AXIS_MAP.add(AXIS_ABSOLUTE);
        AXIS_MAP.add(AXIS_SELF);
        AXIS_MAP.add(AXIS_CHILD);
        AXIS_MAP.add(AXIS_PARENT);
        AXIS_MAP.add(AXIS_ANCESTOR);
        AXIS_MAP.add(AXIS_FOLLOWING);
        AXIS_MAP.add(AXIS_PRECEDING);
        AXIS_MAP.add(AXIS_ATTRIBUTE);
        AXIS_MAP.add(AXIS_NAMESPACE);
        AXIS_MAP.add(AXIS_DESCENDANT);
        AXIS_MAP.add(AXIS_ANCESTOR_OR_SELF);
        AXIS_MAP.add(AXIS_DESCENDANT_OR_SELF);
        AXIS_MAP.add(AXIS_FOLLOWING_SIBLING);
        AXIS_MAP.add(AXIS_PRECEDING_SIBLING);
    }
}

