#include "rossler_sim.h"
#include <grs.h>

#include <iostream>
#include <fstream>

class RosslerGrs : public Grs::ButtonBox, public RosslerSim
{
public:
    typedef RosslerGrs Self;

    RosslerGrs()
        // line 򥰥դϿ
        : graph(2), line1(graph[0]), line2(graph[1])
    {
        // Ͽؿ¹Ԥܥ

        // this->hide() ¹Ԥޤ
        add_func("Quit", sigc::mem_fun(this, &Self::hide));

        // this->step() ¹Ԥޤ
        add_func("Step", sigc::mem_fun(this, &Self::step));

        // this->save() ¹Ԥޤ
        add_file_selection("Save", sigc::mem_fun(this, &Self::save));

        // åɤϿ -- START/STOP ܥޤ
        // ¹ϡϿؿ򷫤֤¹Ԥޤ
        // Ͽؿ false ֤STOP ܥ򲡤Ȥǽλ
        add_thread("", sigc::mem_fun(this, &Self::run));

        // ե饰Ͽ
        add_toggle("Output", out_flag);

        // parlist window ˥ѥ᡼Ͽޤ
        // Grs::ro ꤹȰʹߤѹԲĤΥѥ᡼
        // Grs::rw ꤹѹǽޤ
        parlist << dt << rep_num << a << b << c << Grs::ro << dt;
        // parlist window ɽ/ɽؤܥϿޤ
        parwin.set_title("Par");
        parwin.add(parlist);
        add_window(parwin);

        // varlist window ˥ѥ᡼Ͽޤ
        // Grs::set_digits(int) Ǿʲηꤷޤ
        varlist << Grs::set_digits(1) << t
                << Grs::set_digits(6) << x << y << z;
        // varlist window ɽ/ɽؤܥϿޤ
        varwin.set_title("Var");
        varwin.add(varlist);
        add_window(varwin);

        // graph 
        graph[0].x1 = -10.0;
        graph[0].x2 =  10.0;
        graph[0].y1 = -10.0;
        graph[0].y2 =  10.0;
        graph[1].y1 =  -5.0;
        graph[1].y2 =  25.0;
        graphwin.set_title("Graph");
        graphwin.add(graph);
        add_window(graphwin);

        // line 
        line1.property_fill_color().set_value("red");
        line2.property_fill_color().set_value("blue");
    }

    void step()
    {
        g.clear();
        // integrate λ򥰥դκü
        graph[1].x1 = double(t);
        // ȯŸ -- Τ褦ʷǥǡߤ
        // g << t << '\t' << x << '\t' << y << '\'t << z << '\n';
        integrate(g);
        // integrate λ򥰥դαü
        graph[1].x2 = double(t);
        if (g.get_points(Grs::Index(0)).size() >= 2) {
            // x-y -> line1
            // Index(0) = x, Index(1) = y
            line1.property_points()
                .set_value(g.get_points(Grs::Index(0), Grs::Index(1)));
            // t-z -> line2
            // g.get_points : ҤȤĤ x  t 
            line2.property_points().set_value(g.get_points(Grs::Index(2)));
        }

        // out_flag  on ʤɸϤ
        if (out_flag) std::cout << g;
    }

    bool run()
    {
        step();
        return true;
    }

    bool save(const char* name)
    {
        std::ofstream out(name);
        if (!out) return false;
        out << g;
        return out;
    }

private:
    Grs::Property<bool> out_flag;
    Gtk::Window parwin;
    Grs::ValueList parlist;
    Gtk::Window varwin;
    Grs::ValueList varlist;
    Gtk::Window graphwin;
    Grs::GraphCanvas graph;
    Grs::GraphStream g;
    Gnome::Canvas::Line line1;
    Gnome::Canvas::Line line2;
};

int
main(int argc, char** argv)
{
    Grs::Main app(argc, argv);
    Gtk::Window win;
    win.set_title("grstest");
    RosslerGrs sim;
    win.add(sim);
    win.show_all();
    app.run(win);
    return 0;
}

