/* $Id: graph.cc 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "graph.h"
#include <sstream>

namespace Grs {

Graph::Graph(Group& root, double x1, double y1, double x2, double y2)
    : Gnome::Canvas::Group(root),
      x1(0.0, "x1"), y1(0.0, "y1"), x2(1.0, "x2"), y2(1.0, "y2"),
      m_rect(root), m_left(root), m_right(root), m_top(root), m_bottom(root)
{
    init();
    init_rect(x1, y1, x2, y2);
    init_label();
}

Graph::~Graph()
{
}

const Gnome::Canvas::Rect&
Graph::get_rect() const
{
    return m_rect;
}

void
Graph::set_rect(double x1, double y1, double x2, double y2)
{
    init_rect(x1, y1, x2, y2);
    init_affine();
}

void
Graph::init()
{
    m_rect.property_outline_color().set_value("black");
    m_rect.property_fill_color().set_value("white");
    m_rect.lower_to_bottom();

    x1.connect(sigc::hide(sigc::mem_fun(this, &Graph::init_label)));
    y1.connect(sigc::hide(sigc::mem_fun(this, &Graph::init_label)));
    x2.connect(sigc::hide(sigc::mem_fun(this, &Graph::init_label)));
    y2.connect(sigc::hide(sigc::mem_fun(this, &Graph::init_label)));
}

void
Graph::init_rect(double x1, double y1, double x2, double y2)
{
    m_rect.property_x1().set_value(x1);
    m_rect.property_y1().set_value(y1);
    m_rect.property_x2().set_value(x2);
    m_rect.property_y2().set_value(y2);

    m_left.property_x().set_value(x1);
    m_left.property_y().set_value(y2+10);

    m_right.property_x().set_value(x2);
    m_right.property_y().set_value(y2+10);

    m_top.property_x().set_value(x1-10);
    m_top.property_y().set_value(y1);

    m_bottom.property_x().set_value(x1-10);
    m_bottom.property_y().set_value(y2);
}

void
Graph::init_label()
{
    {
        std::ostringstream dtostr;
        dtostr << double(x1);
        m_left.property_text().set_value(dtostr.str());
    }
    {
        std::ostringstream dtostr;
        dtostr << double(x2);
        m_right.property_text().set_value(dtostr.str());
    }
    {
        std::ostringstream dtostr;
        dtostr << double(y1);
        m_bottom.property_text().set_value(dtostr.str());
    }
    {
        std::ostringstream dtostr;
        dtostr << double(y2);
        m_top.property_text().set_value(dtostr.str());
    }
    init_affine();
}

void
Graph::init_affine()
{
    double x = m_rect.property_x1();
    double w = m_rect.property_x2() - x;
    double y = m_rect.property_y1();
    double h = m_rect.property_y2() - y;
    double affine[6] =
        { w/(x2-x1), 0.0, 0.0, -h/(y2-y1), x-w*x1/(x2-x1), y+h*y2/(y2-y1) };
    affine_absolute(Gnome::Art::AffineTrans(affine));
}

}
