/* $Id: graphcanvas.cc 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "graphcanvas.h"

namespace Grs {

GraphCanvas::GraphCanvas(int num)
    : Gnome::Canvas::Canvas(), num(num, "num"), m_graph()
{
    set_double_buffered();
    set_center_scroll_region(false);
    this->num.connect(sigc::hide(sigc::mem_fun(this, &GraphCanvas::init)));
    init();
}

GraphCanvas::~GraphCanvas()
{
}

void
GraphCanvas::on_size_allocate(Gtk::Allocation& rect)
{
    Gnome::Canvas::Canvas::on_size_allocate(rect);
    init();
}

Grs::Graph&
GraphCanvas::operator[](int index)
{
    return *m_graph[index];
}

void
GraphCanvas::init()
{
    double w = get_width();
    double h = get_height();
    set_scroll_region(0.0, 0.0, w, h);
    h /= num;
    for (std::size_t i = 0; i < unsigned(num); ++i) {
        double xx1 = 30;
        double xx2 = w-20;
        double yy1 = h*i + 10;
        double yy2 = h*(i+1) - 30;
        if (i < m_graph.size()) {
            m_graph[i]->set_rect(xx1, yy1, xx2, yy2);
        } else {
            m_graph.push_back(manage(new Graph(*root(), xx1, yy1, xx2, yy2)));
        }
    }
    for (std::size_t i = num; i < m_graph.size(); ++i) {
        delete m_graph[i];
    }
    m_graph.resize(num);
    queue_draw();
}

}
