/* $Id: graphstream.h 26 2003-12-20 02:42:43Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_GRAPHSTREAM_H
#define GRS_GRAPHSTREAM_H

#include <libgnomecanvasmm/point.h>
#include <libgnomecanvasmm/line.h>
#include <libgnomecanvasmm/rect.h>
#include <libgnomecanvasmm/group.h>
#include <glibmm/refptr.h>
#include <grs/graph.h>
#include <vector>
#include <ostream>

namespace Grs {

typedef std::vector<Glib::RefPtr<Gnome::Canvas::Rect> > GridImage;

class GraphStream
{
public:
    typedef sigc::slot<double, double const*> Function;

public:
    GraphStream();

    Gnome::Canvas::Points get_points(const Function& y);
    Gnome::Canvas::Points get_points(const Function& x, const Function& y);

    Gnome::Canvas::Line* get_line(Gnome::Canvas::Group& group,
            const Function& y);
    Gnome::Canvas::Line* get_line(Gnome::Canvas::Group& group,
            const Function& x, const Function& y);

    GridImage get_gridimage(Gnome::Canvas::Group& group,
            double x_min, double x_max, double y_min, double y_max,
            double z_min, double z_max, unsigned short zlevel);
    GridImage get_gridimage(Graph& graph,
            double z_min, double z_max, unsigned short zlevel);

    void clear();

    GraphStream& operator<<(double data);
    GraphStream& operator<<(char ch);

    friend std::ostream& operator<<(std::ostream& out, const GraphStream& g);

private:
    double m_tmp;
    std::vector<std::vector<double> > m_data;
};

class Index
{
public:
    Index(std::size_t index) : index(index) {}
    double operator()(const double* x) const { return x[index]; }

    operator sigc::slot<double, double const*>()
    {
        return sigc::mem_fun(this, &Index::operator());
    }

private:
    std::size_t index;
};

}

#endif


