/* $Id: threadbutton.cc 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "threadbutton.h"

namespace Grs {

ThreadButton::ThreadButton(const char* name, const sigc::slot<bool>& run)
    : Gtk::ToggleButton(), m_name(name), m_run(run), m_connection()
{
    Gtk::ToggleButton::set_label(m_name + " START"); 
}

ThreadButton::~ThreadButton()
{
}

void
ThreadButton::start()
{
    if (!m_connection.connected()) {
        Gtk::ToggleButton::set_label(m_name + " STOP"); 
        m_connection = Glib::signal_idle().connect(sigc::mem_fun(*this, &ThreadButton::run));
    }
}

void
ThreadButton::stop()
{
    if (m_connection.connected()) {
        Gtk::ToggleButton::set_label(m_name + " START"); 
        m_connection.disconnect();
    }
}

void
ThreadButton::on_toggled()
{
    if (get_active())
        start();
    else
        stop();
}

bool
ThreadButton::run()
{
    if (!m_run()) stop();
    return true;
}

}
