/* $Id: windowbutton.cc 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "windowbutton.h"

namespace Grs {

WindowButton::WindowButton(Gtk::Window& win)
    : Gtk::ToggleButton(win.get_title()), m_win(win)
{
    win.signal_hide().connect(sigc::bind(sigc::mem_fun(*this, &Gtk::ToggleButton::set_active), false));
}

WindowButton::~WindowButton()
{
}

void
WindowButton::on_toggled()
{
    if (get_active())
        m_win.show_all();
    else
        m_win.hide();
}

}
