#include <grs/graphstream.h>
#include <grs/graphcanvas.h>
#include <cmath>

void
make_image(Grs::Graph& graph, Grs::GridImage& image)
{
    static double x0 = 0.0;
    graph.x1 = x0;
    graph.x2 = x0+5.0;
    graph.y1 = 0.0;
    graph.y2 = 5.0;
    Grs::GraphStream g;
    for (int i = 0; i <= 50; ++i) {
        double x = x0 + 0.1*i;
        for (int j = 0; j <= 50; ++j) {
            double y = 0.1*j;
            if (j != 0) g << '\t';
            g << std::sin(x)*std::cos(y);
        }
        g << '\n';
    }
    image = g.get_gridimage(graph, -1.0, 1.0, 16);
    x0 += 5.0;
}

#include <grs/main.h>
#include <grs/buttonbox.h>

int
main(int argc, char** argv)
{
    Grs::Main app(argc, argv);

    Grs::GridImage image;
    Grs::GraphCanvas graph(1);

    Grs::ButtonBox box;
    box.add_func("step", bind(&make_image, ref(graph[0]), ref(image)));
    box.add_window("graph", graph);

    app.run("graphtest", box);
    return 0;
}
