#ifndef ROSSLER_H
#define ROSSLER_H

#include <grs/property.h>

class Rossler
{
public:
    Grs::Property<double> a;
    Grs::Property<double> b;
    Grs::Property<double> c;

public:
    Rossler(double a = 0.344, double b = 0.4, double c = 4.5)
      : a(a, "a"), b(b, "b"), c(c, "c")
    {
    }

    template < typename X, typename F >
        void operator()(const X& x, F& f) const
    {
        f[0] = - x[1] -          x[2];
        f[1] =   x[0] +        a*x[1];
        f[2] = b*x[0] - (c-x[0])*x[2];
    }
};

#endif
