/* $Id: filebutton.cc 53 2004-01-12 19:17:04Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "filebutton.h"

namespace Grs {

FileButton::FileButton(const char* name,
        const sigc::slot<bool, const char*>& func)
: Gtk::Button(name), m_file(name), m_func(func)
{
    m_file.get_ok_button()->signal_clicked()
        .connect(sigc::mem_fun(*this, &FileButton::on_ok_clicked));
    m_file.get_cancel_button()->signal_clicked()
        .connect(sigc::mem_fun(m_file, &Gtk::FileSelection::hide));
}

FileButton::~FileButton()
{
}

void
FileButton::on_clicked()
{
    m_file.show_all();
}

void
FileButton::on_ok_clicked()
{
    if (m_func(m_file.get_filename().c_str())) {
        m_file.hide();
    } else {
        // err msg
    }
}

}
