/* $Id$
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_FILEBUTTON_H
#define GRS_FILEBUTTON_H

#include <gtkmm/button.h>
#include <gtkmm/fileselection.h>

namespace Grs {

class FileButton : public Gtk::Button
{
public:
    FileButton(const char* name, const sigc::slot<bool, const char*>& f);
    virtual ~FileButton();

protected:
    virtual void on_clicked();
    virtual void on_ok_clicked();

private:
    Gtk::FileSelection m_file;
    sigc::slot<bool, const char*> m_func;
};

}

#endif
