/* $Id: graphcanvas.h 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_GRAPHCANVAS_H
#define GRS_GRAPHCANVAS_H

#include <libgnomecanvasmm/canvas.h>
#include <grs/graph.h>

namespace Grs {

class GraphCanvas : public Gnome::Canvas::Canvas
{
public:
    Property<int> num;

public:
    GraphCanvas(int num = 1);
    virtual ~GraphCanvas();

    Grs::Graph& operator[](int index);
    const Grs::Graph& operator[](int index) const;

protected:
    virtual void on_size_allocate(Gtk::Allocation& rect);

private:
    std::vector<Grs::Graph*> m_graph;
    void init();
};

}

#endif
