/* $Id: property.h 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_PROPERTY_H
#define GRS_PROPERTY_H

#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>
#include <ostream>

namespace Grs {

class PropertyBase : public sigc::trackable { };

template < typename T >
class Property : public PropertyBase
{
public:
    explicit Property(const T& val = T(), const char* = "(untitled)");
    ~Property();

    sigc::connection connect(const sigc::slot<void, T>& slot);

    const T& get_value() const;
    void set_value(const T& val);

    const Glib::ustring& get_name() const;
    void set_name(const char* name);

    operator const T&() const;
    Property& operator=(const T& val);
    Property& operator+=(const T& val);
    Property& operator-=(const T& val);
    Property& operator*=(const T& val);
    Property& operator/=(const T& val);

private:
    T m_val;
    Glib::ustring m_name;
    sigc::signal<void, T> m_signal;
};

template < typename T >
std::ostream& operator<<(std::ostream& out, const Property<T>& property);

}

#define GRS_PROPERTY_TCC
#include <grs/property.tcc>
#undef GRS_PROPERTY_TCC

#endif
