/* $Id: threadbutton.h 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_THREADBUTTON_H
#define GRS_THREADBUTTON_H

#include <gtkmm/togglebutton.h>

namespace Grs {

class ThreadButton : public Gtk::ToggleButton
{
public:
    ThreadButton(const char* name, const sigc::slot<bool>& run);
    virtual ~ThreadButton();

    void start();
    void stop();

protected:
    virtual void on_toggled();

private:
    Glib::ustring m_name;
    sigc::slot<bool> m_run;
    sigc::connection m_connection;

    bool run();
};

}

#endif
