/* $Id: valuelist.cc 53 2004-01-12 19:17:04Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "valuelist.h"
#include "entryreal.h"
#include "entryint.h"
#include <gtkmm/label.h>
#include <gtkmm/frame.h>

namespace Grs {

ValueList::ValueList(int digits)
    : Gtk::Table(3, 0), m_default_digits(digits), m_default_writable(true)
{
    Pango::FontDescription font;
    font.set_family("monospace");
    font.set_size(Pango::SCALE*20);
    font.set_weight(Pango::WEIGHT_BOLD);
    modify_font(font);
}

ValueList::~ValueList()
{
}

void
ValueList::set_default_writable(bool writable)
{
    m_default_writable = writable;
}

void
ValueList::set_default_digits(int digits)
{
    m_default_digits = digits;
}

void
ValueList::add_property(Property<double>& property)
{
    add_property(property, m_default_digits, m_default_writable);
}

void
ValueList::add_property(Property<double>& property, int digits)
{
    add_property(property, digits, m_default_writable);
}

void
ValueList::add_property(Property<double>& property, int digits, bool writable)
{
    add_label_(property.get_name());

    EntryReal* entry = manage(new EntryReal(property, digits));
    if (!writable) entry->set_sensitive(false);
    Gtk::Frame* frame = manage(new Gtk::Frame());
    frame->add(*entry);
    attach(*frame, 2, 3, property_n_columns()-1, property_n_columns());
    entry->modify_font(get_modifier_style()->get_font());

    property.connect(sigc::group(sigc::mem_fun(entry, &EntryReal::set_value), sigc::_1));
}

void
ValueList::add_property(Property<int>& property)
{
    add_property(property, m_default_writable);
}

void
ValueList::add_property(Property<int>& property, bool writable)
{
    add_label_(property.get_name());

    EntryInt* entry = manage(new EntryInt(property));
    if (!writable) entry->set_sensitive(false);
    Gtk::Frame* frame = manage(new Gtk::Frame());
    frame->add(*entry);
    attach(*frame, 2, 3, property_n_columns()-1, property_n_columns());
    entry->modify_font(get_modifier_style()->get_font());

    property.connect(sigc::group(sigc::mem_fun(entry, &EntryInt::set_value), sigc::_1));
}

void
ValueList::add_label_(const Glib::ustring& name)
{
    property_n_columns() = property_n_columns() + 1;

    Gtk::Label* label = manage(new Gtk::Label(name));
    attach(*label, 0, 1, property_n_columns()-1, property_n_columns());
    label->modify_font(get_modifier_style()->get_font());

    Gtk::Label* sep = manage(new Gtk::Label(" : "));
    attach(*sep, 1, 2, property_n_columns()-1, property_n_columns());
    sep->modify_font(get_modifier_style()->get_font());
}

ValueList&
operator<<(ValueList& list, const ValueListManip& manip)
{
    manip(list);
    return list;
}

ValueList&
operator<<(ValueList& list, Grs::Property<double>& property)
{
    list.add_property(property);
    return list;
}

ValueList&
operator<<(ValueList& list, Grs::Property<int>& property)
{
    list.add_property(property);
    return list;
}

ValueListManip
set_digits(int digits)
{
    return sigc::group(sigc::mem_fun(&ValueList::set_default_digits),
            sigc::_1, digits);
}

const ValueListManip rw =
    sigc::group(sigc::mem_fun(&ValueList::set_default_writable), sigc::_1, true);

const ValueListManip ro =
    sigc::group(sigc::mem_fun(&ValueList::set_default_writable), sigc::_1, false);

}
