/* $Id: valuelist.cc 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "valuelist.h"
#include "entryreal.h"
#include "entryint.h"
#include <gtkmm/label.h>
#include <gtkmm/frame.h>

#include <boost/bind.hpp>
using boost::bind;
using boost::ref;

namespace Grs {

void
rw(ValueList& val)
{
    val.set_default_writable(true);
}

void
ro(ValueList& val)
{
    val.set_default_writable(false);
}

ValueList::ValueList(int digits)
    : Gtk::Table(3, 0), m_default_digits(digits), m_default_writable(true)
{
    Pango::FontDescription font;
    font.set_family("monospace");
    font.set_size(Pango::SCALE*20);
    font.set_weight(Pango::WEIGHT_BOLD);
    modify_font(font);
}

ValueList::~ValueList()
{
}

void
ValueList::set_default_writable(bool writable)
{
    m_default_writable = writable;
}

void
ValueList::set_default_digits(int digits)
{
    m_default_digits = digits;
}

void
ValueList::add_property(Property<double>& property)
{
    add_property(property, m_default_digits, m_default_writable);
}

void
ValueList::add_property(Property<double>& property, int digits)
{
    add_property(property, digits, m_default_writable);
}

void
ValueList::add_property(Property<double>& property, int digits, bool writable)
{
    add_label_(property.get_name());

    EntryReal* entry = manage(new EntryReal(property, digits));
    if (!writable) entry->set_sensitive(false);
    Gtk::Frame* frame = manage(new Gtk::Frame());
    frame->add(*entry);
    attach(*frame, 2, 3, property_n_columns()-1, property_n_columns());
    entry->modify_font(get_modifier_style()->get_font());

    property.connect(boost::bind(&EntryReal::set_value, entry, _1));
}

void
ValueList::add_property(Property<int>& property)
{
    add_property(property, m_default_writable);
}

void
ValueList::add_property(Property<int>& property, bool writable)
{
    add_label_(property.get_name());

    EntryInt* entry = manage(new EntryInt(property));
    if (!writable) entry->set_sensitive(false);
    Gtk::Frame* frame = manage(new Gtk::Frame());
    frame->add(*entry);
    attach(*frame, 2, 3, property_n_columns()-1, property_n_columns());
    entry->modify_font(get_modifier_style()->get_font());

    property.connect(boost::bind(&EntryInt::set_value, entry, _1));
}

void
ValueList::add_label_(const Glib::ustring& name)
{
    property_n_columns() = property_n_columns() + 1;

    Gtk::Label* label = manage(new Gtk::Label(name));
    attach(*label, 0, 1, property_n_columns()-1, property_n_columns());
    label->modify_font(get_modifier_style()->get_font());

    Gtk::Label* sep = manage(new Gtk::Label(" : "));
    attach(*sep, 1, 2, property_n_columns()-1, property_n_columns());
    sep->modify_font(get_modifier_style()->get_font());
}

ValueList&
ValueList::operator<<(const set_digits& d)
{
    set_default_digits(d.val);
    return *this;
}

ValueList&
ValueList::operator<<(void(*manip)(ValueList&))
{
    manip(*this);
    return *this;
}


ValueListWindow::ValueListWindow(const char* name)
    : Gtk::Window(), m_list()
{
    set_title(name);
    add(m_list);
}

ValueListWindow::~ValueListWindow()
{
}

void
ValueListWindow::set_default_writable(bool writable)
{
    m_list.set_default_writable(writable);
}

void
ValueListWindow::set_default_digits(int digits)
{
    m_list.set_default_digits(digits);
}

void
ValueListWindow::add_property(Property<double>& property)
{
    m_list.add_property(property);
}

void
ValueListWindow::add_property(Property<double>& property, int digits)
{
    m_list.add_property(property, digits);
}

void
ValueListWindow::add_property(Property<double>& property, int digits, bool writable)
{
    m_list.add_property(property, digits, writable);
}

void
ValueListWindow::add_property(Property<int>& property)
{
    m_list.add_property(property);
}

void
ValueListWindow::add_property(Property<int>& property, bool writable)
{
    m_list.add_property(property, writable);
}

ValueListWindow&
ValueListWindow::operator<<(const set_digits& d)
{
    m_list << d;
    return *this;
}

ValueListWindow&
ValueListWindow::operator<<(void (*manip)(ValueList&))
{
    manip(m_list);
    return *this;
}

}
