/* $Id: buttonbox.cc 38 2003-12-20 15:23:59Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "buttonbox.h"
#include "windowbutton.h"
#include "threadbutton.h"
#include "togglebutton.h"
#include "funcbutton.h"
#include "filebutton.h"

namespace Grs {

ButtonBox::ButtonBox()
    : Gtk::VButtonBox()
{
}

ButtonBox::~ButtonBox()
{
}

void
ButtonBox::add_window(Gtk::Window& window)
{
    WindowButton* button = manage(new WindowButton(window));
    pack_start(*button, Gtk::PACK_SHRINK);
}

void
ButtonBox::add_func(const char* name, const boost::function<void()>& function)
{
    FuncButton* button = manage(new FuncButton(name, function));
    pack_start(*button, Gtk::PACK_SHRINK);
}

void
ButtonBox::add_toggle(const char* name, const boost::function<void(bool)>& function)
{
    ToggleButton* button = manage(new ToggleButton(name, function));
    pack_start(*button, Gtk::PACK_SHRINK);
}

void
ButtonBox::add_toggle(const char* name,
        const boost::function<void()>& on, const boost::function<void()>& off)
{
    ToggleButton* button = manage(new ToggleButton(name, on, off));
    pack_start(*button, Gtk::PACK_SHRINK);
}

void
ButtonBox::add_toggle(const char* name, Property<bool>& flag)
{
    ToggleButton* button = manage(new ToggleButton(name, flag));
    pack_start(*button, Gtk::PACK_SHRINK);
}


void
ButtonBox::add_thread(const char* name, const boost::function<bool()>& function)
{
    ThreadButton* button = manage(new ThreadButton(name, function));
    pack_start(*button, Gtk::PACK_SHRINK);
}

void
ButtonBox::add_file_selection(const char* name,
        const boost::function<bool(const char*)>& function)
{
    FileButton* button = manage(new FileButton(name, function));
    pack_start(*button, Gtk::PACK_SHRINK);
}


ButtonBoxWindow::ButtonBoxWindow(const char* title)
    : Gtk::Window(), m_list()
{
    set_title(title);
    add(m_list);
}

ButtonBoxWindow::~ButtonBoxWindow()
{
}

void
ButtonBoxWindow::add_window(Gtk::Window& window)
{
    m_list.add_window(window);
}

void
ButtonBoxWindow::add_func(const char* name, const boost::function<void()>& function)
{
    m_list.add_func(name, function);
}

void
ButtonBoxWindow::add_toggle(const char* name, const boost::function<void(bool)>& function)
{
    m_list.add_toggle(name, function);
}

void
ButtonBoxWindow::add_toggle(const char* name,
        const boost::function<void()>& on, const boost::function<void()>& off)
{
    m_list.add_toggle(name, on, off);
}

void
ButtonBoxWindow::add_toggle(const char* name, Property<bool>& flag)
{
    m_list.add_toggle(name, flag);
}

void
ButtonBoxWindow::add_thread(const char* name, const boost::function<bool()>& function)
{
    m_list.add_thread(name, function);
}

void
ButtonBoxWindow::add_file_selection(const char* name,
        const boost::function<bool(const char*)>& function)
{
    m_list.add_file_selection(name, function);
}

}
