/* $Id: entryreal.h 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_ENTRYREAL_H
#define GRS_ENTRYREAL_H

#include <gtkmm/drawingarea.h>
#include <grs/property.h>
#include <pangomm.h>

namespace Grs {

class EntryReal : public Gtk::DrawingArea
{
public:
    EntryReal(Property<double>& property, int digits = 6);
    virtual ~EntryReal();

    void set_digits(int digits);
    void set_position(int position);
    void set_value(double value);

    int get_digits() const;
    int get_position() const;
    int get_position(double x, double y) const;
    double get_value() const;

protected:
    virtual void on_style_changed(const Glib::RefPtr<Gtk::Style>& old_style);
    virtual bool on_expose_event(GdkEventExpose* event);
    virtual bool on_button_press_event(GdkEventButton* event);
    virtual bool on_key_press_event(GdkEventKey* event);
    virtual bool on_scroll_event(GdkEventScroll* event);
    virtual bool on_focus_in_event(GdkEventFocus* event);
    virtual bool on_focus_out_event(GdkEventFocus* event);

private:
    double m_value;
    int m_digits;
    int m_position;
    boost::signal<void(double)> m_signal;
    Glib::RefPtr<Pango::Layout> m_layout;

    void init_text();
    void init_cursol();
};

}

#endif
