/* $Id: valuelist.h 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_VALUELIST_H
#define GRS_VALUELIST_H

#include <gtkmm/table.h>
#include <gtkmm/window.h>
#include <grs/property.h>

namespace Grs {

struct set_digits;

class ValueList : public Gtk::Table
{
public:
    ValueList(int default_digits = 6);
    virtual ~ValueList();

    void set_default_writable(bool writable);
    void set_default_digits(int digits);

    void add_property(Property<double>& property);
    void add_property(Property<double>& property, int digits);
    void add_property(Property<double>& property, int digits, bool writable);
    void add_property(Property<int>& property);
    void add_property(Property<int>& property, bool writable);

    ValueList& operator<<(const set_digits& digits);
    ValueList& operator<<(void (*manip)(ValueList&));
    template < typename T >
        ValueList& operator<<(Property<T>& property);

private:
    int m_default_digits;
    bool m_default_writable;
    void add_label_(const Glib::ustring& name);
};

class ValueListWindow : public Gtk::Window
{
public:
    ValueListWindow(const char* name);
    virtual ~ValueListWindow();

    void set_default_writable(bool writable);
    void set_default_digits(int digits);

    void add_property(Property<double>& property);
    void add_property(Property<double>& property, int digits);
    void add_property(Property<double>& property, int digits, bool writable);
    void add_property(Property<int>& property);
    void add_property(Property<int>& property, bool writable);

    ValueListWindow& operator<<(const set_digits& digits);
    ValueListWindow& operator<<(void (*manip)(ValueList&));
    template < typename T >
        ValueListWindow& operator<<(Property<T>& property);

private:
    ValueList m_list;
};

class set_digits
{
public:
    set_digits(int val) : val(val) {};
private:
    friend class ValueList;
    int val;
};

void ro(ValueList& val);
void rw(ValueList& val);

}

namespace Grs {

template < typename T >
ValueList&
ValueList::operator<<(Grs::Property<T>& property)
{
    add_property(property);
    return *this;
}

template < typename T >
ValueListWindow&
ValueListWindow::operator<<(Grs::Property<T>& property)
{
    m_list.add_property(property);
    return *this;
}

}

#endif
