#include <grs/graphstream.h>
#include <grs/graphwindow.h>
#include <cmath>

void
make_image(Grs::Graph& graph, Grs::GridImage& image)
{
    static double x0 = 0.0;
    graph.x1 = x0;
    graph.x2 = x0+5.0;
    graph.y1 = 0.0;
    graph.y2 = 5.0;
    Grs::GraphStream g;
    for (int i = 0; i <= 50; ++i) {
        double x = x0 + 0.1*i;
        for (int j = 0; j <= 50; ++j) {
            double y = 0.1*j;
            if (j != 0) g << '\t';
            g << std::sin(x)*std::cos(y);
        }
        g << '\n';
    }
    image = g.get_gridimage(graph, -1.0, 1.0, 16);
    x0 += 5.0;
}

#include <libgnomecanvasmm/init.h>
#include <gtkmm/main.h>
#include <grs/buttonboxwindow.h>

#include <boost/bind.hpp>
using boost::bind;
using boost::ref;

int
main(int argc, char** argv)
{
    Gnome::Canvas::init();
    Gtk::Main app(argc, argv);

    Grs::GridImage image;
    Grs::GraphWindow graph("graph", 1);
    graph.set_default_size(200, 200);

    Grs::ButtonBoxWindow win("graphtest");
    win.add_func("step", bind(&make_image, ref(graph[0]), ref(image)));
    win.add_window(graph);
    win.show_all();

    Gtk::Main::run(win);
    return 0;
}
