/* $Id: buttonboxwindow.cc 53 2004-01-12 19:17:04Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#include "buttonboxwindow.h"
#include "windowbutton.h"
#include "threadbutton.h"
#include "togglebutton.h"
#include "funcbutton.h"
#include "filebutton.h"

namespace Grs {

ButtonBoxWindow::ButtonBoxWindow(const char* title)
    : Gtk::Window(), m_list()
{
    set_title(title);
    add(m_list);
}

ButtonBoxWindow::~ButtonBoxWindow()
{
}

void
ButtonBoxWindow::add_window(Gtk::Window& window)
{
    m_list.add_window(window);
}

void
ButtonBoxWindow::add_func(const char* name, const boost::function<void()>& func)
{
    m_list.add_func(name, func);
}

void
ButtonBoxWindow::add_thread(const char* name, const boost::function<bool()>& func)
{
    m_list.add_thread(name, func);
}

void
ButtonBoxWindow::add_toggle(const char* name, Property<bool>& flag)
{
    m_list.add_toggle(name, flag);
}

void
ButtonBoxWindow::add_toggle(const char* name, const boost::function<void()>& on, const boost::function<void()>& off)
{
    m_list.add_toggle(name, on, off);
}

void
ButtonBoxWindow::add_toggle(const char* name, const boost::function<void(bool)>& func)
{
    m_list.add_toggle(name, func);
}

void
ButtonBoxWindow::add_file_selection(const char* name, const boost::function<bool(const char*)>& func)
{
    m_list.add_file_selection(name, func);
}

}
