/* $Id: entryint.h 53 2004-01-12 19:17:04Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_ENTRYINT_H
#define GRS_ENTRYINT_H

#include <gtkmm/drawingarea.h>
#include <grs/property.h>
#include <pangomm.h>

namespace Grs {

class EntryInt : public Gtk::DrawingArea
{
public:
    explicit EntryInt(Property<int>& property);
    virtual ~EntryInt();

    void set_position(int position);
    void set_value(int value);

    int get_position() const;
    int get_position(double x, double y) const;
    double get_value() const;

protected:
    virtual void on_style_changed(const Glib::RefPtr<Gtk::Style>& old_style);
    virtual bool on_expose_event(GdkEventExpose* event);
    virtual bool on_button_press_event(GdkEventButton* event);
    virtual bool on_key_press_event(GdkEventKey* event);
    virtual bool on_scroll_event(GdkEventScroll* event);
    virtual bool on_focus_in_event(GdkEventFocus* event);
    virtual bool on_focus_out_event(GdkEventFocus* event);

private:
    int m_value;
    int m_position;
    boost::signal<void (int)> m_signal;
    Glib::RefPtr<Pango::Layout> m_layout;

    void init_text();
    void init_cursol();
};

}

#endif
