/* $Id: graph.h 24 2003-12-20 01:38:09Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_GRAPH_H
#define GRS_GRAPH_H

#include <libgnomecanvasmm/group.h>
#include <libgnomecanvasmm/rect.h>
#include <libgnomecanvasmm/text.h>
#include <grs/property.h>

namespace Grs {

class Graph : public Gnome::Canvas::Group
{
public:
    Property<double> x1;
    Property<double> y1;
    Property<double> x2;
    Property<double> y2;

public:
    Graph(Group& group, double x1, double y1, double x2, double y2);
    virtual ~Graph();

    void set_rect(double x1, double y1, double x2, double y2);
    const Gnome::Canvas::Rect& get_rect() const;

private:
    Gnome::Canvas::Rect m_rect;
    Gnome::Canvas::Text m_left;
    Gnome::Canvas::Text m_right;
    Gnome::Canvas::Text m_top;
    Gnome::Canvas::Text m_bottom;
    void init();
    void init_rect(double x1, double y1, double x2, double y2);
    void init_label();
    void init_affine();
};

}

#endif
