/* $Id: valuelist.h 53 2004-01-12 19:17:04Z takekawa $
 * Copyright (C) 2003 Takashi Takekawa
 * This file is part of the Grs Library
 *
 * This library is free software; You may redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have recieved a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundtion, Inc., 59 Temple Place, Suite 330, Bostom, MA
 * 02111-1307 USA.
 */

#ifndef GRS_VALUELIST_H
#define GRS_VALUELIST_H

#include <boost/function.hpp>
#include <gtkmm/table.h>
#include <gtkmm/window.h>
#include <grs/property.h>

namespace Grs {

class ValueList : public Gtk::Table
{
public:
    explicit ValueList(int default_digits = 6);
    virtual ~ValueList();

    void set_default_writable(bool writable);
    void set_default_digits(int digits);

    void add_property(Property<double>& property);
    void add_property(Property<double>& property, int digits);
    void add_property(Property<double>& property, int digits, bool writable);
    void add_property(Property<int>& property);
    void add_property(Property<int>& property, bool writable);

private:
    int m_default_digits;
    bool m_default_writable;
    void add_label_(const Glib::ustring& name);
};

typedef boost::function<void(ValueList& list)> ValueListManip;
ValueList& operator<<(ValueList& list, const ValueListManip& manip);
ValueList& operator<<(ValueList& list, Property<double>& property);
ValueList& operator<<(ValueList& list, Property<int>& property);

extern const ValueListManip ro;
extern const ValueListManip rw;
ValueListManip set_digits(int val);

}

#endif
