/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusBrowserModel {
    public static final int SORT_INDEX_OFFENCE = 0;
    public static final int SORT_INDEX_DEFENSE = 1;
    public static final int SORT_INDEX_HITPOINT = 2;
    public static final int SORT_INDEX_SP_ATTACK = 3;
    public static final int SORT_INDEX_NONE = 4;
    private List<Rider> riders;

    StatusBrowserModel() {
        this.setUp();
    }

    public void setUp() {
        this.riders = new ArrayList<Rider>();
        try {
            String line;
            File csv = new File("data.csv");
            BufferedReader reader = new BufferedReader(new FileReader(csv));
            while ((line = reader.readLine()) != null) {
                if (line.length() >= 2 && line.charAt(0) == '/' && line.charAt(1) == '/') continue;
                StringTokenizer st = new StringTokenizer(line, ",");
                this.riders.add(new Rider(this.getStringValue(st), this.getIntValue(st), this.getStringValue(st), this.getInt16Value(st), this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), new int[]{this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), this.getIntValue(st)}, new RiderSkill(this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), this.getIntValue(st), this.getInt16Value(st)), this.getIntValue(st)));
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Rider search(String series, int number) {
        Rider rider = null;
        for (Rider r : this.riders) {
            if (!r.getSeries().equals(series) || r.getNumber() != number) continue;
            rider = r;
            break;
        }
        return rider;
    }

    public DeckStatus getStatus(Rider vanguard, Rider rearguard) {
        return new DeckStatus(vanguard, rearguard);
    }

    public List<DeckStatus> getStatusList(Rider rider, boolean isVanguard, Filter filter, int sort) {
        ArrayList<DeckStatus> list = new ArrayList<DeckStatus>();
        for (Rider partner : this.riders) {
            DeckStatus status;
            if (rider.getName().equals(partner.getName())) continue;
            DeckStatus deckStatus = status = isVanguard ? this.getStatus(rider, partner) : this.getStatus(partner, rider);
            if (filter.isFiltered(status)) continue;
            list.add(status);
        }
        if (sort != 4) {
            Collections.sort(list, new StatusComparator(sort));
        }
        return list;
    }

    public ArrayList<String> getSeriesList() {
        ArrayList<String> seriesList = new ArrayList<String>();
        for (Rider rider : this.riders) {
            if (seriesList.contains(rider.getSeries())) continue;
            seriesList.add(rider.getSeries());
        }
        return seriesList;
    }

    public ArrayList<String> getNumberList(String series) {
        ArrayList<String> numList = new ArrayList<String>();
        for (Rider rider : this.riders) {
            if (!rider.getSeries().equals(series)) continue;
            numList.add(String.valueOf(rider.getNumber()));
        }
        return numList;
    }

    public ArrayList<Rider> getKamenridedRiderList() {
        ArrayList<Rider> riderList = new ArrayList<Rider>();
        for (Rider rider : this.riders) {
            if (!rider.isAbleToKamenrided()) continue;
            riderList.add(rider);
        }
        return riderList;
    }

    private String getStringValue(StringTokenizer st) {
        return st.nextToken().trim();
    }

    private int getIntValue(StringTokenizer st) {
        return Integer.parseInt(st.nextToken().trim());
    }

    private int getInt16Value(StringTokenizer st) {
        return Integer.parseInt(st.nextToken().trim(), 16);
    }
}

