/*
 * Decompiled with CFR 0.152.
 */
class DeckStatus
extends Rider {
    private static final int CHEMISTRY_UNIT = 50;
    private Rider vanguard;
    private Rider supporter;
    private Rider breaker;

    DeckStatus(Rider vanguard, Rider supporter, Rider breaker) {
        super("status", 0, 0, 0, 0, 0, 0, new int[4], new RiderSkill(0, 0, 0, 0, 0, 0), 0);
        this.vanguard = vanguard;
        this.supporter = supporter;
        this.breaker = breaker;
        this.calcChemistry(vanguard, supporter, breaker);
        this.offense = vanguard.getOffense() + this.chemistry[0] * 50;
        this.defense = vanguard.getDefense() + this.chemistry[1] * 50;
        this.hitpoint = vanguard.getHitpoint() + supporter.getHitpoint() + breaker.getHitpoint() + this.chemistry[3] * 50;
        this.specialAttack = vanguard.getSpecialAttack() + this.chemistry[2] * 50;
        this.rearGuardTactics = supporter.getRearGuardTactics();
        this.reflectSkills(vanguard, supporter, breaker);
    }

    private void calcChemistry(Rider vgd, Rider spt, Rider brk) {
        int[] chemi1st = new int[4];
        int[] chemi2nd = new int[4];
        this.calcChemistrySub(vgd, spt, chemi1st);
        this.calcChemistrySub(vgd, brk, chemi2nd);
        int i = 0;
        while (i < 4) {
            this.chemistry[i] = chemi1st[i] + chemi2nd[i];
            ++i;
        }
    }

    private void calcChemistrySub(Rider vanguard, Rider rearguard, int[] chemi) {
        int i = 0;
        while (i < 4) {
            chemi[i] = vanguard.getChemistry(i) + rearguard.getChemistry(i);
            ++i;
        }
        int first = 0;
        int second = first + 1;
        int i2 = first + 1;
        while (i2 < 4) {
            if (chemi[first] < chemi[i2]) {
                second = first;
                first = i2;
            } else if (chemi[second] < chemi[i2]) {
                second = i2;
            }
            ++i2;
        }
        int n = first;
        chemi[n] = chemi[n] + 1;
        i2 = 0;
        while (i2 < 4) {
            if (i2 != first && i2 != second) {
                chemi[i2] = 0;
            }
            ++i2;
        }
    }

    private void reflectSkills(Rider vanguard, Rider supporter, Rider breaker) {
        if (vanguard.isVanguardSkillValid(supporter, breaker)) {
            this.offense += vanguard.getOffenseSkill();
            this.defense += vanguard.getDefenseSkill();
            this.hitpoint += vanguard.getHitpointSkill();
            this.specialAttack += vanguard.getSpecialAttackSkill();
        }
        if (supporter.isRearguardSkillValid(vanguard, breaker)) {
            this.offense += supporter.getOffenseSkill();
            this.defense += supporter.getDefenseSkill();
            this.hitpoint += supporter.getHitpointSkill();
            this.specialAttack += supporter.getSpecialAttackSkill();
        }
        if (breaker.isRearguardSkillValid(vanguard, supporter)) {
            this.offense += breaker.getOffenseSkill();
            this.defense += breaker.getDefenseSkill();
            this.hitpoint += breaker.getHitpointSkill();
            this.specialAttack += breaker.getSpecialAttackSkill();
        }
    }

    @Override
    public String toString() {
        String str = new String("");
        str = String.valueOf(str) + "\u30bc\u30f3\u30a8\u30a4(" + this.vanguard.getSeries() + "-" + this.vanguard.getNumber() + "),";
        str = String.valueOf(str) + "\u30b3\u30a6\u30a8\u30a4(" + this.supporter.getSeries() + "-" + this.supporter.getNumber() + ")\t=>\t";
        str = String.valueOf(str) + "\u30b3\u30a6\u30b2\u30ad\uff1a" + this.offense + ", ";
        str = String.valueOf(str) + "\u30dc\u30a6\u30ae\u30e7 \uff1a" + this.defense + ", ";
        str = String.valueOf(str) + "\u30bf\u30a4\u30ea\u30e7\u30af \uff1a" + this.hitpoint + ", ";
        str = String.valueOf(str) + "\u30d2\u30c3\u30b5\u30c4 \uff1a " + this.specialAttack;
        return str;
    }

    public Rider getVanguard() {
        return this.vanguard;
    }

    public Rider getSupporter() {
        return this.supporter;
    }

    public Rider getBreaker() {
        return this.breaker;
    }
}

