/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class RiderSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox series;
    private JComboBox numbers;
    private StatusBrowserModel model;
    private StatusDialog dialog;

    RiderSelectionPanel(String str, final StatusBrowserModel model) {
        this.model = model;
        ArrayList<String> seriesList = this.model.getSeriesList();
        JLabel label = new JLabel(str);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.series = new JComboBox<Object>(seriesList.toArray());
        this.series.setMaximumSize(new Dimension(75, Short.MAX_VALUE));
        this.series.setPreferredSize(new Dimension(75, 25));
        this.numbers = new JComboBox();
        this.numbers.setMaximumSize(new Dimension(75, Short.MAX_VALUE));
        this.numbers.setPreferredSize(new Dimension(75, 25));
        final JLabel name = new JLabel();
        name.setMaximumSize(new Dimension(275, Short.MAX_VALUE));
        JButton stButton = new JButton("\u2026");
        stButton.setMaximumSize(new Dimension(25, Short.MAX_VALUE));
        stButton.setPreferredSize(new Dimension(25, 25));
        this.dialog = new StatusDialog();
        this.setLayout(new BoxLayout(this, 0));
        this.add(label);
        this.add(this.series);
        this.add(new JLabel("\uff0d"));
        this.add(this.numbers);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.add(name);
        this.add(Box.createHorizontalGlue());
        this.add(stButton);
        this.series.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedSeries = (String)RiderSelectionPanel.this.series.getSelectedItem();
                ArrayList<String> nums = model.getNumberList(selectedSeries);
                RiderSelectionPanel.this.numbers.removeAllItems();
                Iterator i = nums.iterator();
                while (i.hasNext()) {
                    RiderSelectionPanel.this.numbers.addItem(i.next());
                }
            }
        });
        this.numbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                name.setText("");
                Rider r = RiderSelectionPanel.this.getSelectedRider();
                if (r != null) {
                    name.setText(r.getName());
                }
            }
        });
        stButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rider r = RiderSelectionPanel.this.getSelectedRider();
                if (r != null) {
                    RiderSelectionPanel.this.dialog.setRider(r);
                    RiderSelectionPanel.this.dialog.setVisible(true);
                }
            }
        });
    }

    public Rider getSelectedRider() {
        Rider rider = null;
        String s = (String)this.series.getSelectedItem();
        String n = (String)this.numbers.getSelectedItem();
        if (s != null && n != null) {
            rider = this.model.search(s, Integer.parseInt(n));
        }
        return rider;
    }
}

