/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JRadioButton;
import javax.swing.table.DefaultTableModel;

class CheckAction
implements ActionListener {
    private RiderSelectionPanel vanguard;
    private RiderSelectionPanel supporter;
    private RiderSelectionPanel breaker;
    private StatusBrowserModel model;
    private DefaultTableModel tableModel;
    private JRadioButton[] modeButton;
    private FilterPanel filter;
    private OptionPanel options;

    CheckAction(RiderSelectionPanel vanguard, RiderSelectionPanel supporter, RiderSelectionPanel breaker, StatusBrowserModel model, DefaultTableModel tableModel, JRadioButton[] modeButton, FilterPanel filter, OptionPanel options) {
        this.vanguard = vanguard;
        this.supporter = supporter;
        this.breaker = breaker;
        this.model = model;
        this.tableModel = tableModel;
        this.modeButton = modeButton;
        this.filter = filter;
        this.options = options;
    }

    public void actionPerformed(ActionEvent e) {
        Rider r1 = this.vanguard.getSelectedRider();
        Rider r2 = this.supporter.getSelectedRider();
        Rider r3 = this.breaker.getSelectedRider();
        if (this.modeButton[0].isSelected()) {
            if (!(r1 == null || r2 == null || r3 == null || r1.getName().equals(r2.getName()) || r1.getName().equals(r3.getName()) || r2.getName().equals(r3.getName()))) {
                DeckStatus status = this.model.getStatus(r1, r2, r3);
                this.tableModel.addRow(new Object[]{r1.toString(), r2.toString(), r3.toString(), status.getOffense(), status.getDefense(), status.getHitpoint(), status.getSpecialAttack()});
            }
        } else {
            Rider rider = null;
            int riderPos = 1;
            if (this.modeButton[1].isSelected()) {
                rider = r1;
            } else if (this.modeButton[2].isSelected()) {
                rider = r2;
                riderPos = 2;
            } else if (this.modeButton[3].isSelected()) {
                rider = r3;
                riderPos = 3;
            }
            if (rider != null) {
                List<DeckStatus> list = this.model.getStatusList(rider, riderPos, this.filter.getFilter(), this.options.getSortIndex());
                for (DeckStatus status : list) {
                    Rider van = status.getVanguard();
                    Rider spt = status.getSupporter();
                    Rider brk = status.getBreaker();
                    this.tableModel.addRow(new Object[]{van.toString(), spt.toString(), brk.toString(), status.getOffense(), status.getDefense(), status.getHitpoint(), status.getSpecialAttack()});
                }
            }
        }
    }
}

