/*
 * Decompiled with CFR 0.152.
 */
public class Rider {
    private String series;
    private int number;
    protected String name;
    protected int offense;
    protected int defense;
    protected int hitpoint;
    protected int specialAttack;
    protected int rearGuardTactics;
    protected int[] chemistry;
    protected RiderSkill riderSkill;
    protected int attribute;
    protected int rarity;
    protected String skillStr;
    public static final int GANGAN_SEMERO = 0;
    public static final int AITE_WO_BUTTOBASE = 1;
    public static final int SUPPORT_HA_MAKASERO = 2;
    public static final int AITE_WO_YOKUMIRO = 3;
    public static final int GUARD_WO_KATAMERO = 4;
    public static final int CHEMISTRY_INDEX_OFFENSE = 0;
    public static final int CHEMISTRY_INDEX_DEFENSE = 1;
    public static final int CHEMISTRY_INDEX_SP_ATTACK = 2;
    public static final int CHEMISTRY_INDEX_HITPOINT = 3;
    public static final int CHEMISTRY_NUM = 4;
    public static final int ATTR_SPEED = 1;
    public static final int ATTR_POWER = 2;
    public static final int ATTR_TECHNIQUE = 4;
    public static final int ATTR_SUPER_SPEED = 0x10000001;
    public static final int ATTR_SUPER_POWER = 0x10000002;
    public static final int ATTR_SUPER_TECHNIQUE = 0x10000004;
    public static final int ATTR_SUPER_MASK = 0x10000000;
    public static final int RARITY_NORMAL = 1;
    public static final int RARITY_RARE = 2;
    public static final int RARITY_SP_CARD = 3;
    public static final int RARITY_SUPER_RARE = 4;
    public static final int RARITY_LEGEND_RARE = 5;
    public static final int POS_VANGUARD = 1;
    public static final int POS_SUPPORTER = 2;
    public static final int POS_BREAKER = 3;

    Rider(String name, int attribute, int offense, int defense, int hitpoint, int specialAttack, int rearGuardTactics, int[] chemistry, RiderSkill skill, int rarity, String skillStr) {
        this.name = name;
        this.attribute = attribute;
        this.chemistry = new int[4];
        this.offense = offense;
        this.defense = defense;
        this.hitpoint = hitpoint;
        this.specialAttack = specialAttack;
        this.rearGuardTactics = rearGuardTactics;
        int i = 0;
        while (i < 4) {
            this.chemistry[i] = chemistry[i];
            ++i;
        }
        this.riderSkill = skill;
        this.rarity = rarity;
        this.skillStr = skillStr;
    }

    Rider(String series, int number, String name, int attribute, int offense, int defense, int hitpoint, int specialAttack, int rearGuardTactics, int[] chemistry, RiderSkill skill, int rarity, String skillStr) {
        this(name, attribute, offense, defense, hitpoint, specialAttack, rearGuardTactics, chemistry, skill, rarity, skillStr);
        this.series = series;
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public int getOffense() {
        return this.offense;
    }

    public int getDefense() {
        return this.defense;
    }

    public int getHitpoint() {
        return this.hitpoint;
    }

    public int getSpecialAttack() {
        return this.specialAttack;
    }

    public int getRearGuardTactics() {
        return this.rearGuardTactics;
    }

    public int getChemistry(int index) {
        return this.chemistry[index];
    }

    public int getAttribute() {
        return this.attribute;
    }

    public int getOffenseSkill() {
        return this.riderSkill.getOffense();
    }

    public int getDefenseSkill() {
        return this.riderSkill.getDefense();
    }

    public int getHitpointSkill() {
        return this.riderSkill.getHitpoint();
    }

    public int getSpecialAttackSkill() {
        return this.riderSkill.getSpecialAttack();
    }

    public String getSeries() {
        return this.series;
    }

    public int getNumber() {
        return this.number;
    }

    public int getRarity() {
        return this.rarity;
    }

    public String getSkillStr() {
        return this.skillStr;
    }

    public boolean isVanguardSkillValid(Rider supporter, Rider breaker) {
        return this.riderSkill.isSkillValid(this, supporter, true) || this.riderSkill.isSkillValid(this, breaker, true);
    }

    public boolean isRearguardSkillValid(Rider vanguard, Rider anotherRider) {
        return this.riderSkill.isSkillValid(this, vanguard, false) || this.riderSkill.isSkillValid(this, anotherRider, false);
    }

    public boolean isEqual(Rider rider) {
        return rider.getSeries().equals(this.series) && rider.getNumber() == this.number;
    }

    public String toString() {
        return new String(String.valueOf(this.name) + "(" + this.series + "-" + this.number + ")");
    }
}

