/*
 * Decompiled with CFR 0.152.
 */
class RiderSkill {
    public static final int SKILL_POS_NONE = 3;
    public static final int SKILL_POS_VANGUARD = 1;
    public static final int SKILL_POS_REARGUARD = 2;
    public static final int SKILL_POS_MASK = 15;
    public static final int SKILL_ATTR_NONE = 0;
    public static final int SKILL_ATTR_SAME_AS_FELLOW = 16;
    public static final int SKILL_ATTR_SAME_AS_ENEMY = 32;
    public static final int SKILL_ATTR_MASK = 240;
    public static final int SKILL_SPECIAL_RIDER = 0x10000000;
    private int offense;
    private int defense;
    private int hitpoint;
    private int specialAttack;
    private int attackPoint;
    private int condition;

    RiderSkill(int offense, int defense, int hitpoint, int spAttack, int ap, int condition) {
        this.offense = offense;
        this.defense = defense;
        this.hitpoint = hitpoint;
        this.specialAttack = spAttack;
        this.attackPoint = ap;
        this.condition = condition;
    }

    public boolean isSkillValid(Rider owner, Rider partner, boolean isVanguard) {
        boolean isValid;
        int posMask = 2;
        if (isVanguard) {
            posMask = 1;
        }
        boolean bl = isValid = (this.condition & posMask) == posMask;
        if (isValid) {
            if ((this.condition & 0x10000000) != 0x10000000) {
                int attrCond = this.condition & 0xF0;
                if (attrCond == 32) {
                    isValid = false;
                } else if (attrCond == 16) {
                    isValid = (owner.getAttribute() & partner.getAttribute()) != 0;
                }
            } else {
                isValid = this.isRiderSpecifiedSkillValid(owner, partner);
            }
        }
        return isValid;
    }

    public boolean isRiderSpecifiedSkillValid(Rider owner, Rider partner) {
        boolean isValid = false;
        if (owner.getSeries().equals("8") && owner.getNumber() == 48) {
            isValid = partner.getName().contains("\u9f8d\u9a0e");
        } else if (owner.getSeries().equals("002") && owner.getNumber() == 44) {
            isValid = partner.getName().contains("\u30b9\u30ab\u30eb");
        }
        return isValid;
    }

    public int getOffense() {
        return this.offense;
    }

    public int getDefense() {
        return this.defense;
    }

    public int getHitpoint() {
        return this.hitpoint;
    }

    public int getSpecialAttack() {
        return this.specialAttack;
    }

    public int getAttackPoint() {
        return this.attackPoint;
    }

    public int getCondition() {
        return this.condition;
    }
}

