/*
 * Decompiled with CFR 0.152.
 */
public class Rider {
    private String series;
    private int number;
    protected String name;
    protected int offense;
    protected int defense;
    protected int hitpoint;
    protected int specialAttack;
    protected int rearGuardTactics;
    protected int[] chemistry;
    protected RiderSkill riderSkill;
    protected int attribute;
    protected int rarity;
    protected String skillStr;
    public static final int GANGAN_SEMERO = 0;
    public static final int AITE_WO_BUTTOBASE = 1;
    public static final int SUPPORT_HA_MAKASERO = 2;
    public static final int AITE_WO_YOKUMIRO = 3;
    public static final int GUARD_WO_KATAMERO = 4;
    public static final int CHEMISTRY_INDEX_OFFENSE = 0;
    public static final int CHEMISTRY_INDEX_DEFENSE = 1;
    public static final int CHEMISTRY_INDEX_SP_ATTACK = 2;
    public static final int CHEMISTRY_INDEX_HITPOINT = 3;
    public static final int CHEMISTRY_NUM = 4;
    public static final int ATTR_SPEED = 1;
    public static final int ATTR_POWER = 2;
    public static final int ATTR_TECHNIQUE = 4;
    public static final int ATTR_SUPER_SPEED = 0x10000001;
    public static final int ATTR_SUPER_POWER = 0x10000002;
    public static final int ATTR_SUPER_TECHNIQUE = 0x10000004;
    public static final int ATTR_SUPER_MASK = 0x10000000;
    public static final int RARITY_NORMAL = 1;
    public static final int RARITY_RARE = 2;
    public static final int RARITY_SP_CARD = 3;
    public static final int RARITY_SUPER_RARE = 4;
    public static final int RARITY_LEGEND_RARE = 5;
    public static final int POS_VANGUARD = 1;
    public static final int POS_SUPPORTER = 2;
    public static final int POS_BREAKER = 3;

    Rider(String name, int attribute, int offense, int defense, int hitpoint, int specialAttack, int rearGuardTactics, int[] chemistry, RiderSkill skill, int rarity, String skillStr) {
        this.name = name;
        this.attribute = attribute;
        this.chemistry = new int[4];
        this.offense = offense;
        this.defense = defense;
        this.hitpoint = hitpoint;
        this.specialAttack = specialAttack;
        this.rearGuardTactics = rearGuardTactics;
        int chemiTemp = chemistry[3];
        chemistry[3] = chemistry[2];
        chemistry[2] = chemiTemp;
        int i = 0;
        while (i < 4) {
            this.chemistry[i] = chemistry[i];
            ++i;
        }
        this.riderSkill = skill;
        this.rarity = rarity;
        this.skillStr = skillStr;
    }

    Rider(String series, int number, String name, int attribute, int offense, int defense, int hitpoint, int specialAttack, int rearGuardTactics, int[] chemistry, RiderSkill skill, int rarity, String skillStr) {
        this(name, attribute, offense, defense, hitpoint, specialAttack, rearGuardTactics, chemistry, skill, rarity, skillStr);
        this.series = series;
        this.number = number;
    }

    public Rider kamenride(Rider rider) {
        Rider r = this;
        if (this.isKamenridable() && rider != null && rider.isAbleToKamenrided()) {
            int k_o = 0;
            int k_d = 0;
            int k_h = 0;
            int k_s = 0;
            int rarity = rider.getRarity();
            int upValue = rarity == 5 ? 150 : (rarity == 4 || rarity == 2 ? 100 : 50);
            switch (rider.getRearGuardTactics()) {
                case 0: {
                    k_o += upValue;
                    k_s += upValue;
                    break;
                }
                case 1: {
                    k_o += upValue;
                    k_h += upValue;
                    break;
                }
                case 2: {
                    k_o += upValue;
                    k_d += upValue;
                    break;
                }
                case 3: {
                    k_d += upValue;
                    k_h += upValue;
                    break;
                }
                case 4: {
                    k_d += upValue;
                    k_s += upValue;
                }
            }
            int chemiTemp = this.chemistry[3];
            this.chemistry[3] = this.chemistry[2];
            this.chemistry[2] = chemiTemp;
            r = new Rider(this.series, this.number, this.name, rider.getAttribute(), this.offense + k_o, this.defense + k_d, this.hitpoint + k_h, this.specialAttack + k_s, this.rearGuardTactics, this.chemistry, this.riderSkill, rarity, this.skillStr);
        }
        return r;
    }

    public String getName() {
        return this.name;
    }

    public int getOffense() {
        return this.offense;
    }

    public int getDefense() {
        return this.defense;
    }

    public int getHitpoint() {
        return this.hitpoint;
    }

    public int getSpecialAttack() {
        return this.specialAttack;
    }

    public int getRearGuardTactics() {
        return this.rearGuardTactics;
    }

    public int getChemistry(int index) {
        return this.chemistry[index];
    }

    public int getAttribute() {
        return this.attribute;
    }

    public int getOffenseSkill() {
        return this.riderSkill.getOffense();
    }

    public int getDefenseSkill() {
        return this.riderSkill.getDefense();
    }

    public int getHitpointSkill() {
        return this.riderSkill.getHitpoint();
    }

    public int getSpecialAttackSkill() {
        return this.riderSkill.getSpecialAttack();
    }

    public String getSeries() {
        return this.series;
    }

    public int getNumber() {
        return this.number;
    }

    public int getRarity() {
        return this.rarity;
    }

    public boolean isKamenridable() {
        return this.name.equals("\u30c7\u30a3\u30b1\u30a4\u30c9") || this.name.equals("\u30c7\u30a3\u30b1\u30a4\u30c9\u6fc0\u60c5\u614b");
    }

    public boolean isAbleToKamenrided() {
        return this.name.equals("\u30af\u30a6\u30acMF") || this.name.equals("\u30a2\u30ae\u30c8GF") || this.name.equals("\u9f8d\u9a0e") || this.name.equals("\u30d5\u30a1\u30a4\u30ba") || this.name.equals("\u30d6\u30ec\u30a4\u30c9") || this.name.equals("\u97ff\u9b3c") || this.name.equals("\u30ab\u30d6\u30c8RF") || this.name.equals("\u96fb\u738bSF") || this.name.equals("\u30ad\u30d0KF");
    }

    public String getSkillStr() {
        return this.skillStr;
    }

    public boolean isVanguardSkillValid(Rider supporter, Rider breaker) {
        return this.riderSkill.isSkillValid(this, supporter, true) || this.riderSkill.isSkillValid(this, breaker, true);
    }

    public boolean isRearguardSkillValid(Rider vanguard, Rider anotherRider) {
        return this.riderSkill.isSkillValid(this, vanguard, false) || this.riderSkill.isSkillValid(this, anotherRider, false);
    }

    public boolean isEqual(Rider rider) {
        return rider.getSeries().equals(this.series) && rider.getNumber() == this.number;
    }

    public String toString() {
        return new String(String.valueOf(this.name) + "(" + this.series + "-" + this.number + ")");
    }
}

