/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import jp.sourceforge.gtibuilder.util.CharArray;
import jp.sourceforge.gtibuilder.util.Debug;

public class TextColoring
implements DocumentListener {
    private JTextPane tp = null;
    private StyledDocument document = null;
    private boolean running = false;
    private static String[][] colorText = new String[20][20];
    private static boolean inited = false;

    public TextColoring(JTextPane jTextPane) {
        this.tp = jTextPane;
        this.document = this.tp.getStyledDocument();
        this.document.addDocumentListener(this);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(final DocumentEvent documentEvent) {
        Debug.print("!-!-!-!-insertUpdate++++" + documentEvent);
        if (this.running) {
            return;
        }
        new Thread(){

            public void run() {
                if (documentEvent.getLength() != 1) {
                    TextColoring.this.changeDocument(documentEvent.getOffset(), documentEvent.getLength());
                } else {
                    if (documentEvent.getOffset() + documentEvent.getLength() < TextColoring.this.tp.getText().length()) {
                        TextColoring.this.changeDocument(documentEvent.getOffset(), documentEvent.getLength() + 1);
                    }
                    TextColoring.this.changeDocument(documentEvent.getOffset(), documentEvent.getLength());
                }
            }
        }.start();
    }

    public void removeUpdate(final DocumentEvent documentEvent) {
        Debug.print("!-!-!-!-removeUpdate++++" + documentEvent);
        if (this.running) {
            return;
        }
        new Thread(){

            public void run() {
                if (documentEvent.getOffset() == 0) {
                    if (TextColoring.this.tp.getText().length() != 0) {
                        TextColoring.this.changeDocument(documentEvent.getOffset(), 1);
                    }
                } else if (TextColoring.this.tp.getText().length() >= documentEvent.getOffset() + 2) {
                    TextColoring.this.changeDocument(documentEvent.getOffset() - 1, 3);
                } else if (TextColoring.this.tp.getText().length() >= documentEvent.getOffset() + 1) {
                    TextColoring.this.changeDocument(documentEvent.getOffset() - 1, 2);
                }
            }
        }.start();
    }

    private void changeDocument(int n, int n2) {
        this.running = true;
        Debug.print("OFFSET:" + n);
        --n2;
        char[] cArray = this.tp.getText().toCharArray();
        if (Character.isWhitespace(cArray[n])) {
            int n3;
            for (n3 = n; n3 <= n + n2 && Character.isWhitespace(cArray[n3]); ++n3) {
            }
            if (n3 != n + n2) {
                int n4 = n3;
                if (Character.isWhitespace(cArray[n + n2])) {
                    for (n3 = n + n2; n3 != n && Character.isWhitespace(cArray[n3]); --n3) {
                    }
                    this.coloringText(n4, n3);
                } else {
                    for (n3 = n + n2; n3 != cArray.length && !Character.isWhitespace(cArray[n3]); ++n3) {
                    }
                    this.coloringText(n4, --n3);
                }
            }
        } else {
            int n5;
            for (n5 = n; n5 >= 0 && !Character.isWhitespace(cArray[n5]); --n5) {
            }
            if (++n5 != n + n2) {
                int n6 = n5;
                if (Character.isWhitespace(cArray[n + n2])) {
                    for (n5 = n + n2; n5 != n && Character.isWhitespace(cArray[n5]); --n5) {
                    }
                    this.coloringText(n6, n5);
                } else {
                    for (n5 = n + n2; n5 != cArray.length && !Character.isWhitespace(cArray[n5]); ++n5) {
                    }
                    this.coloringText(n6, --n5);
                }
            } else {
                this.coloringText(n5, n + n2);
            }
        }
        this.running = false;
    }

    private void coloringText(int n, int n2) {
        int n3;
        char[] cArray;
        int n4;
        if (n >= n2) {
            return;
        }
        CharArray charArray = new CharArray();
        char[] cArray2 = this.tp.getText().substring(n, n2 + 1).toCharArray();
        Word word = new Word();
        word.start = n;
        word.end = n2 + 1;
        for (n4 = 0; n2 - n + 1 > n4; ++n4) {
            if (!Character.isLetterOrDigit(cArray2[n4])) {
                if (charArray.size() != 0) {
                    cArray = new char[charArray.size()];
                    for (n3 = 0; n3 < charArray.size(); ++n3) {
                        cArray[n3] = charArray.getAt(n3);
                    }
                    word.end = n + n4;
                    word.word = new String(cArray);
                    this.coloring(word);
                    charArray.clear();
                    word = new Word();
                    word.start = n + n4 + 1;
                    Thread.yield();
                    continue;
                }
                word.start = n + n4 + 1;
                continue;
            }
            charArray.add(cArray2[n4]);
        }
        if (charArray.size() != 0) {
            cArray = new char[charArray.size()];
            for (n3 = 0; n3 < charArray.size(); ++n3) {
                cArray[n3] = charArray.getAt(n3);
            }
            word.end = n + n4;
            word.word = new String(cArray);
            this.coloring(word);
            charArray.clear();
        }
    }

    private void coloring(Word word) {
        TextColoring.init();
        int n = word.end - word.start;
        if (n > 19) {
            return;
        }
        boolean bl = false;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        for (int i = 0; i < colorText[n].length; ++i) {
            String string = colorText[n][i];
            if (!string.equals(word.word)) continue;
            Debug.print("MATCH! " + word);
            StyleConstants.setBold(simpleAttributeSet, true);
            Color color = new Color(0, 0, 200);
            StyleConstants.setForeground(simpleAttributeSet, color);
            bl = true;
            break;
        }
        this.document.setCharacterAttributes(word.start, n, simpleAttributeSet, true);
    }

    private static void init() {
        int n;
        if (inited) {
            return;
        }
        Vector[] vectorArray = new Vector[20];
        for (int i = 0; i < colorText.length; ++i) {
            vectorArray[i] = new Vector();
        }
        String[] stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while", "void", "true", "false"};
        for (n = 0; n < stringArray.length; ++n) {
            vectorArray[stringArray[n].length()].addElement(stringArray[n]);
        }
        for (n = 0; n < vectorArray.length; ++n) {
            Enumeration enumeration = vectorArray[n].elements();
            TextColoring.colorText[n] = new String[vectorArray[n].size()];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                TextColoring.colorText[n][n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
        Debug.print("init");
        inited = true;
    }

    public static void reset() {
        inited = false;
    }

    class Word {
        public int start = 0;
        public int end = 0;
        public String word = new String();

        Word() {
        }

        public String toString() {
            return "Start AT:" + this.start + " / END AT:" + this.end + " / WORD:\"" + this.word + "\"";
        }
    }
}

