/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.plugin;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipFile;
import jp.sourceforge.gtibuilder.io.UserPreferences;
import jp.sourceforge.gtibuilder.plugin.DynamicZipClassLoader;
import jp.sourceforge.gtibuilder.plugin.Plugin;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.ErrorDialog;
import jp.sourceforge.gtibuilder.util.StringArray;
import jp.sourceforge.gtibuilder.util.TextBuffer;

public class PluginManager {
    private Vector plugins = null;
    private StringArray list = null;
    private ProjectManager manager = null;
    private boolean inited = false;
    private Plugin[] pluginInstances = null;
    private boolean[] enabled = null;
    private boolean[] removable = null;
    private boolean[] removed = null;
    private String[] files = null;
    private Vector removedPlugin = new Vector();
    static /* synthetic */ Class class$jp$sourceforge$gtibuilder$plugin$PluginManager;

    public PluginManager(ProjectManager projectManager) {
        UserPreferences userPreferences = UserPreferences.loadPreferences("PluginDataBase");
        if (userPreferences.getStringArray().getKeys().length == 0) {
            this.list = new StringArray((class$jp$sourceforge$gtibuilder$plugin$PluginManager == null ? (class$jp$sourceforge$gtibuilder$plugin$PluginManager = PluginManager.class$("jp.sourceforge.gtibuilder.plugin.PluginManager")) : class$jp$sourceforge$gtibuilder$plugin$PluginManager).getResourceAsStream("PluginDataBase.properties"));
            userPreferences.setStringArray(this.list);
            userPreferences.saveData();
        } else {
            this.list = userPreferences.getStringArray();
        }
        this.manager = projectManager;
        String[] stringArray = this.list.getKeys();
        this.plugins = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.plugins.addElement(stringArray[i]);
        }
    }

    public void init() {
        if (this.inited) {
            return;
        }
        Plugin[] pluginArray = this.getInstances();
        this.pluginInstances = pluginArray;
        for (int i = 0; pluginArray.length > i; ++i) {
            this.init(i);
        }
        this.inited = true;
    }

    public void init(Plugin plugin) {
        for (int i = 0; this.pluginInstances.length > i; ++i) {
            if (!plugin.equals(this.pluginInstances[i])) continue;
            this.init(i);
            break;
        }
    }

    public void init(int n) {
        Plugin[] pluginArray = this.pluginInstances;
        if (this.enabled[n]) {
            if (pluginArray[n].getMenuAddPoint() == 1) {
                this.manager.addMenuAt("FILE", pluginArray[n].getJMenuItem());
            } else if (pluginArray[n].getMenuAddPoint() == 2) {
                this.manager.addMenuAt("EDIT", pluginArray[n].getJMenuItem());
            } else if (pluginArray[n].getMenuAddPoint() == 4) {
                this.manager.addMenuAt("TOOLS", pluginArray[n].getJMenuItem());
            } else if (pluginArray[n].getMenuAddPoint() == 3) {
                this.manager.addMenuAt("PROJECT", pluginArray[n].getJMenuItem());
            } else if (pluginArray[n].getMenuAddPoint() == 5) {
                this.manager.addMenuAt("HELP", pluginArray[n].getJMenuItem());
            } else {
                this.manager.addMenu(pluginArray[n].getJMenu());
            }
            pluginArray[n].setProjectManager(this.manager);
        }
    }

    public void addPlugin(Plugin plugin, boolean bl, boolean bl2, String string) {
        Plugin[] pluginArray = new Plugin[this.pluginInstances.length + 1];
        boolean[] blArray = new boolean[this.pluginInstances.length + 1];
        boolean[] blArray2 = new boolean[this.pluginInstances.length + 1];
        boolean[] blArray3 = new boolean[this.pluginInstances.length + 1];
        String[] stringArray = new String[this.pluginInstances.length + 1];
        System.arraycopy(this.pluginInstances, 0, pluginArray, 0, this.pluginInstances.length);
        System.arraycopy(this.enabled, 0, blArray, 0, this.pluginInstances.length);
        System.arraycopy(this.removable, 0, blArray2, 0, this.pluginInstances.length);
        System.arraycopy(this.removed, 0, blArray3, 0, this.pluginInstances.length);
        System.arraycopy(this.files, 0, stringArray, 0, this.pluginInstances.length);
        pluginArray[this.pluginInstances.length] = plugin;
        blArray[this.pluginInstances.length] = bl;
        blArray2[this.pluginInstances.length] = bl2;
        stringArray[this.pluginInstances.length] = string;
        blArray3[this.pluginInstances.length] = false;
        this.pluginInstances = pluginArray;
        this.enabled = blArray;
        this.removable = blArray2;
        this.files = stringArray;
        this.removed = blArray3;
    }

    private Plugin getInstance(String string) {
        try {
            String[] stringArray = TextBuffer.cutString((String)this.list.getContent(string), " ");
            Class clazz = null;
            Debug.print(stringArray[3]);
            if (stringArray[3].equals("%default%")) {
                clazz = Class.forName(stringArray[0]);
            } else {
                try {
                    DynamicZipClassLoader dynamicZipClassLoader = new DynamicZipClassLoader(new ZipFile(stringArray[3]));
                    clazz = dynamicZipClassLoader.findClass(stringArray[0]);
                }
                catch (IOException iOException) {
                    new ErrorDialog(iOException);
                }
            }
            return (Plugin)clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.print(exception);
            new ErrorDialog(exception).show();
            return null;
        }
    }

    private Plugin[] getInstances() {
        Enumeration enumeration = this.plugins.elements();
        Plugin[] pluginArray = new Plugin[this.plugins.size()];
        this.enabled = new boolean[pluginArray.length];
        this.removable = new boolean[pluginArray.length];
        this.removed = new boolean[pluginArray.length];
        this.files = new String[pluginArray.length];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = TextBuffer.cutString((String)this.list.getContent(string), " ");
            this.enabled[n] = Boolean.valueOf(stringArray[1]);
            this.removable[n] = Boolean.valueOf(stringArray[2]);
            this.files[n] = stringArray[3];
            this.removed[n] = false;
            pluginArray[n] = this.getInstance(string);
            ++n;
        }
        return pluginArray;
    }

    public Plugin[] getPlugins() {
        return this.pluginInstances;
    }

    public Plugin getPlugin(int n) {
        return this.pluginInstances[n];
    }

    public Plugin getPlugin(String string) {
        return this.pluginInstances[this.getPluginIndex(string)];
    }

    public boolean isEnablePlugin(int n) {
        return this.enabled[n];
    }

    public boolean isRemovablePlugin(int n) {
        return this.removable[n];
    }

    public String getClassLoadFile(int n) {
        return this.files[n];
    }

    public void setEnablePlugin(int n, boolean bl) {
        this.enabled[n] = bl;
    }

    public void removedPlugin(int n) {
        if (this.removable[n]) {
            this.removed[n] = true;
        }
    }

    public boolean isRemoved(int n) {
        return this.removed[n];
    }

    public int getPluginIndex(String string) {
        for (int i = 0; this.pluginInstances.length > i; ++i) {
            if (!this.pluginInstances[i].getPluginName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void savePluginDataBase() {
        UserPreferences userPreferences = UserPreferences.loadPreferences("PluginDataBase");
        for (int i = 0; this.pluginInstances.length > i; ++i) {
            Debug.print("REMOVED?:" + i + "=" + this.removed[i]);
            if (!this.removed[i]) {
                userPreferences.setData(this.pluginInstances[i].getPluginName(), this.pluginInstances[i].getClass().getName() + " " + this.isEnablePlugin(i) + " " + this.isRemovablePlugin(i) + " " + this.getClassLoadFile(i));
                continue;
            }
            userPreferences.getStringArray().remove(this.pluginInstances[i].getPluginName(), 1);
        }
        userPreferences.saveData();
    }

    public void closeProject(Project project) {
        for (int i = 0; i < this.pluginInstances.length; ++i) {
            this.pluginInstances[i].closeProject(project);
        }
    }

    public void exit() {
        for (int i = 0; i < this.pluginInstances.length; ++i) {
            this.pluginInstances[i].exit();
        }
        this.savePluginDataBase();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

