/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PRIME_CANDIDATE_WINDOW_H__
#define __PRIME_CANDIDATE_WINDOW_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

static GType prime_type_candidate_window;

#define PRIME_TYPE_CANDIDATE_WINDOW             prime_type_candidate_window 
#define PRIME_CANDIDATE_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), PRIME_TYPE_CANDIDATE_WINDOW, PrimeCandidateWindow))
#define PRIME_CANDIDATE_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), PRIME_TYPE_CANDIDATE_WINDOW, PrimeCandidateWindowClass))
#define PRIME_IS_CANDIDATE_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PRIME_TYPE_CANDIDATE_WINDOW))
#define PRIME_IS_CANDIDATE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PRIME_TYPE_CANDIDATE_WINDOW))
#define PRIME_CANDIDATE_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), PRIME_TYPE_CANDIDATE_WINDOW, PrimeCandidateWindowClass))

typedef struct _PrimeCandidateWindow         PrimeCandidateWindow;
typedef struct _PrimeCandidateWindowClass    PrimeCandidateWindowClass;

struct _PrimeCandidateWindow
{
	GtkWindow parent;
};

struct _PrimeCandidateWindowClass
{
	GtkWindowClass parent_class;
};

void		      prime_candidate_window_register_type (GTypeModule *module);
PrimeCandidateWindow *prime_candidate_window_new           (void);

void   prime_candidate_window_set_candidates        (PrimeCandidateWindow *window,
				                     gchar **candidates);
gchar *prime_candidate_window_get_candidate         (PrimeCandidateWindow *window);
gchar *prime_candidate_window_get_candidate_from_index
						    (PrimeCandidateWindow *window,
						     guint index);

void   prime_candidate_window_select_prev_candidate (PrimeCandidateWindow *window);
void   prime_candidate_window_select_next_candidate (PrimeCandidateWindow *window);

void   prime_candidate_window_prev_page             (PrimeCandidateWindow *window);
void   prime_candidate_window_next_page             (PrimeCandidateWindow *window);

G_END_DECLS

#endif /* __PRIME_CANDIDATE_WINDOW_H__ */
