﻿/*  Preset.cs $
 	
 	   This file is part of the HandBrake source code.
 	   Homepage: <http://handbrake.fr>.
 	   It may be used under the terms of the GNU General Public License. */

/*
 * This file come from HandBrake source code by http://handbrake.fr/ , 
 * and modified by hylom <hylomm@gmail.com> for HandBrake Japanese version.
 * It may be used under the terms of the GNU General Public License.
 * last modified date: Tue Jan 5 19:19:44 2010 +0900
 */


using System;

namespace Handbrake.Presets
{
    public class Preset
    {
        /// <summary>
        /// Get or Set the category which the preset resides under
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// Get or Set the preset name
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Get or set the preset query
        /// </summary>
        public string Query { get; set; }

        /// <summary>
        /// Get or set the usage of Picture Settings in presets.
        /// </summary>
        public Boolean PictureSettings { get; set; }

        /// <summary>
        /// The version number which associates this preset with a HB build
        /// </summary>
        public string Version { get; set; }
    }
}