/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.loggerserver;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.ParameterParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;

public class HascUploaderServlet
extends HttpServlet {
    private static final long serialVersionUID = -4718231431886490254L;
    public static IFolder basefolder = null;
    byte[] boundary;

    public HascUploaderServlet() {
    }

    public HascUploaderServlet(String greeting) {
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        req.getAttributeNames();
        int len = req.getContentLength();
        this.boundary = this.getBoundary(req.getHeader("Content-Type"));
        ServletInputStream sis = req.getInputStream();
        if (len > 0x200000) {
            response.setContentType("text/plain");
            response.setStatus(400);
            return;
        }
        byte[] buf = new byte[len];
        int off = 0;
        int rest = len;
        while (off < len) {
            int k = sis.read(buf, off, rest);
            if (k < 0) break;
            if (off + k > len) continue;
            rest -= k;
            off += k;
        }
        String s = new String(buf);
        String bd = new String(this.boundary);
        int bdp = 0;
        String ss = s;
        while (bdp >= 0) {
            bdp = s.indexOf(bd);
            if (bdp < 0) continue;
            ss = s.substring(bdp + bd.length() + 1);
            bdp = ss.indexOf(bd);
            s = ss;
            if (bdp < 0 || (ss = ss.substring(0, bdp - 2)).indexOf("terminalId") >= 0) continue;
            this.saveAccFile(ss);
        }
        response.setContentType("text/plain");
        response.setStatus(200);
    }

    public String getLine(String str, int offset) {
        int end = str.indexOf("\n", offset);
        if (end >= 0) {
            return str.substring(offset, end);
        }
        return "";
    }

    void saveAccFile(String buffer) {
        String disposition = this.getLine(buffer, 0);
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(disposition, new char[]{';', ','});
        String filename = (String)params.get("filename");
        String basename = filename.substring(0, filename.indexOf(".") - 1);
        String accfilename = String.valueOf(basename) + "-acc" + ".csv";
        String gyrofilename = String.valueOf(basename) + "-gyro" + ".csv";
        String magfilename = String.valueOf(basename) + "-mag" + ".csv";
        String locationfilename = String.valueOf(basename) + "-loc" + ".csv";
        String metafilename = String.valueOf(basename) + ".meta";
        System.out.println("Uploaded FileName: " + filename);
        int pos = disposition.length() + 2;
        try {
            StringWriter labelFile = new StringWriter();
            StringWriter accFile = new StringWriter();
            StringWriter gyroFile = new StringWriter();
            StringWriter magFile = new StringWriter();
            StringWriter locFile = new StringWriter();
            String line = this.getLine(buffer, pos);
            boolean acc = false;
            boolean gyro = false;
            boolean mag = false;
            boolean loc = false;
            while (line.length() > 0) {
                String[] dd;
                if (line.contains("ACC")) {
                    dd = line.split("ACC\t");
                    if (dd.length > 1) {
                        accFile.write(String.valueOf(dd[1]) + "\n");
                        if (!acc) {
                            acc = true;
                        }
                    }
                } else if (line.contains("GYRO")) {
                    dd = line.split("GYRO\t");
                    if (dd.length > 1) {
                        gyroFile.write(String.valueOf(dd[1]) + "\n");
                        if (!gyro) {
                            gyro = true;
                        }
                    }
                } else if (line.contains("MAG")) {
                    dd = line.split("MAG\t");
                    if (dd.length > 1) {
                        magFile.write(String.valueOf(dd[1]) + "\n");
                        if (!mag) {
                            mag = true;
                        }
                    }
                } else if (line.contains("LOC")) {
                    dd = line.split("LOC\t");
                    if (dd.length > 1) {
                        locFile.write(String.valueOf(dd[1]) + "\n");
                        if (!loc) {
                            loc = true;
                        }
                    }
                } else if (line.contains("TAGS")) {
                    dd = line.split("TAGS\t");
                    if (dd.length > 1) {
                        labelFile.write("Tags: " + dd[1] + "\n");
                    }
                } else if (line.contains("LOG_VERSION")) {
                    dd = line.split("LOG_VERSION\t");
                    if (dd.length > 1) {
                        labelFile.write("LogVersion: " + dd[1] + "\n");
                    }
                } else if (line.contains("TERMINAL_ID")) {
                    dd = line.split("TERMINAL_ID\t");
                    if (dd.length > 1) {
                        labelFile.write("TerminalID: " + dd[1] + "\n");
                    }
                } else if (line.contains("TERMINAL_TYPE")) {
                    dd = line.split("TERMINAL_TYPE\t");
                    if (dd.length > 1) {
                        labelFile.write("TerminalType: " + dd[1] + "\n");
                    }
                } else if (line.contains("COMMENT")) {
                    dd = line.split("COMMENT\t");
                    if (dd.length > 1) {
                        labelFile.write("Comment: " + dd[1] + "\n");
                    }
                } else {
                    System.out.println("no output[" + line + "]");
                }
                line = this.getLine(buffer, pos += line.length() + 1);
            }
            accFile.close();
            gyroFile.close();
            labelFile.close();
            if (acc) {
                this.saveDataToResourceFile(accFile.toString(), accfilename);
            }
            if (gyro) {
                this.saveDataToResourceFile(gyroFile.toString(), gyrofilename);
            }
            if (mag) {
                this.saveDataToResourceFile(magFile.toString(), magfilename);
            }
            if (loc) {
                this.saveDataToResourceFile(locFile.toString(), locationfilename);
            }
            this.saveDataToResourceFile(labelFile.toString(), metafilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void saveDataToResourceFile(String data, String fileName) {
        try {
            ByteArrayInputStream bain = new ByteArrayInputStream(data.getBytes("UTF-8"));
            IFile outf = basefolder.getFile(fileName);
            if (outf.exists()) {
                outf.setContents((InputStream)bain, true, false, null);
            } else {
                outf.create((InputStream)bain, true, null);
            }
            bain.close();
            System.out.println("wrote file:" + fileName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

