/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.loggerserver.handlers;

import jp.hasc.loggerserver.HascLoggerServer;
import jp.hasc.loggerserver.handlers.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class StartServerHandler
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        try {
            String dialogMessage;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            IFolder f = null;
            if (selection instanceof StructuredSelection) {
                StructuredSelection ss = (StructuredSelection)selection;
                for (Object item : ss) {
                    if (!(item instanceof IFolder)) continue;
                    f = (IFolder)item;
                }
            }
            if (HascLoggerServer.server == null) {
                if (f == null) {
                    this.showMessage(window.getShell(), Messages.StartServerHandler_SelectDataFolder);
                    return null;
                }
                InputDialog dlg = new InputDialog(window.getShell(), Messages.StartServerHandler_PluginLabel, Messages.StartServerHandler_TCPPortNumber, Integer.toString(HascLoggerServer.portNum), null);
                if (dlg.open() != 0) {
                    return null;
                }
                HascLoggerServer.portNum = Integer.parseInt(dlg.getValue());
                dialogMessage = Messages.StartServerHandler_StartServer;
            } else {
                dialogMessage = Messages.StartServerHandler_StopServer;
            }
            HascLoggerServer.toggleServer(f);
            this.showMessage(window.getShell(), dialogMessage);
            return null;
        }
        catch (Exception ex) {
            this.showMessage(window.getShell(), ex.toString());
            return null;
        }
    }

    private void showMessage(Shell shell, String dialogMessage) {
        MessageDialog.openInformation((Shell)shell, (String)Messages.StartServerHandler_PluginLabel, (String)dialogMessage);
    }
}

