/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.blockdiagram;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.HashMap;
import java.util.Map;
import jp.hasc.hasctool.core.blockdiagram.model.AbstractBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.core.blockdiagram.model.PortReference;
import jp.hasc.hasctool.core.messaging.MessageConnector;
import jp.hasc.hasctool.core.messaging.MessageProcessor;
import jp.hasc.hasctool.core.runtime.RuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;

public class BlockDiagramExecutor {
    private RuntimeContext runtimeContext_;
    private BlockDiagram blockDiagram_;
    private Map<String, AbstractBlock> blocks_;
    private Map<String, Object> blockInstances_;
    public static final String KEY_BLOCK_DIAGRAM_FILE_NAME = "blockDiagramFileName";

    public BlockDiagramExecutor() {
        this.runtimeContext_ = new RuntimeContext();
    }

    public BlockDiagramExecutor(RuntimeContext runtimeContext) {
        this.runtimeContext_ = runtimeContext;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext_;
    }

    public void execute(BlockDiagram bd) {
        this.doLoad(bd);
        this.doCreateInstances();
        this.doSetup();
        this.doConnect();
        this.doStart();
    }

    public void doLoad(BlockDiagram bd) {
        this.blockDiagram_ = bd;
        this.blocks_ = new HashMap<String, AbstractBlock>();
        this.blockInstances_ = new HashMap<String, Object>();
        for (AbstractBlock b : this.blockDiagram_.getBlocks()) {
            this.blocks_.put(b.getName(), b);
        }
    }

    public void doCreateInstances() {
        for (AbstractBlock b : this.blockDiagram_.getBlocks()) {
            this.blockInstances_.put(b.getName(), b.newRuntimeInstance(this));
        }
    }

    public void doSetup() {
        for (AbstractBlock b : this.blockDiagram_.getBlocks()) {
            Object bean = this.blockInstances_.get(b.getName());
            if (!(bean instanceof RuntimeBean)) continue;
            RuntimeBean rb = (RuntimeBean)bean;
            rb.setup(this.getRuntimeContext());
        }
    }

    public void doConnect() {
        for (Connection c : this.blockDiagram_.getConnections()) {
            MessageConnector op = (MessageConnector)this.getPort(c.getOutputPortReference());
            MessageProcessor ip = (MessageProcessor)this.getPort(c.getInputPortReference());
            op.connect(ip);
        }
    }

    public void doStart() {
        this.runtimeContext_.startTasks();
    }

    public AbstractBlock getBlock(String name) {
        return this.blocks_.get(name);
    }

    public Object getPort(PortReference pr) {
        AbstractBlock b = this.blocks_.get(pr.getBlockName());
        if (b == null) {
            throw new RuntimeException("block '" + pr.getBlockName() + "' not found");
        }
        Object bi = this.blockInstances_.get(pr.getBlockName());
        return b.getRuntimePortByName(bi, pr.getPortName());
    }

    public static XStream newXStream() {
        XStream xs = new XStream((HierarchicalStreamDriver)new DomDriver());
        xs.autodetectAnnotations(true);
        xs.aliasPackage("model", BlockDiagram.class.getPackage().getName());
        return xs;
    }

    public Object getBlockInsance(String blockName) {
        return this.blockInstances_.get(blockName);
    }
}

