/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.blockdiagram.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.hasc.hasctool.core.blockdiagram.BlockDiagramExecutor;
import jp.hasc.hasctool.core.blockdiagram.model.AbstractBlock;
import jp.hasc.hasctool.core.blockdiagram.model.PortReference;
import jp.hasc.hasctool.core.util.CoreUtil;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanBlock
extends AbstractBlock {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="class")
    private String runtimeClassName;
    private LinkedHashMap<String, Object> properties = null;

    public Map<String, Object> properties() {
        return this.getOrCreateProperties();
    }

    public Object getProperty(String name) {
        return this.getOrCreateProperties().get(name);
    }

    private LinkedHashMap<String, Object> getOrCreateProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties;
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.getOrCreateProperties().remove(name);
        } else {
            this.getOrCreateProperties().put(name, value);
        }
    }

    @Override
    public PortReference getPortByName(String name) {
        return new PortReference(this.getName(), name);
    }

    public PortReference getPortByNameAndIndex(String name, int index) {
        return new PortReference(this.getName(), String.valueOf(name) + "[" + index + "]");
    }

    @Override
    public Object newRuntimeInstance(BlockDiagramExecutor exec) {
        try {
            Class<?> runtimeClass = Class.forName(this.runtimeClassName);
            Constructor<?> c = runtimeClass.getConstructor(new Class[0]);
            Object bean = c.newInstance(new Object[0]);
            if (this.properties != null) {
                for (Map.Entry<String, Object> e : this.properties.entrySet()) {
                    PropertyUtils.setProperty(bean, (String)e.getKey(), (Object)e.getValue());
                }
            }
            return bean;
        }
        catch (Exception ex) {
            CoreUtil.throwAsRuntimeException(ex);
            return null;
        }
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public void setRuntimeClassName(String className) {
        this.runtimeClassName = className;
    }
}

