/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.blockdiagram.test;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.core.blockdiagram.model.BlockDiagram;
import jp.hasc.hasctool.core.blockdiagram.model.Connection;
import jp.hasc.hasctool.core.runtime.sink.LineWriterSink;
import jp.hasc.hasctool.core.runtime.source.LineReaderSource;
import junit.framework.TestCase;

public class XStreamTest
extends TestCase {
    public static final String INPUT_FILE_NAME = "test1.acc.csv";
    public static final String OUTPUT_FILE_NAME = "output.csv";

    public void test1() {
        XStream xs = XStreamTest.newXStream();
        BlockDiagram bd1 = XStreamTest.createSampleDiagram();
        String s = xs.toXML((Object)bd1);
        System.out.println(s);
        xs = XStreamTest.newXStream();
        BlockDiagram bd2 = (BlockDiagram)xs.fromXML(s);
        XStream xs2 = XStreamTest.newXStream();
        String s2 = xs2.toXML((Object)bd2);
        XStreamTest.assertEquals((String)s, (String)s2);
    }

    private static XStream newXStream() {
        XStream xs = new XStream((HierarchicalStreamDriver)new DomDriver());
        xs.autodetectAnnotations(true);
        xs.aliasPackage("model", BlockDiagram.class.getPackage().getName());
        return xs;
    }

    public static BlockDiagram createSampleDiagram() {
        BlockDiagram bd = new BlockDiagram();
        BeanBlock reader = new BeanBlock();
        reader.setName("reader");
        reader.setRuntimeClassName(LineReaderSource.class.getName());
        reader.setProperty("fileName", INPUT_FILE_NAME);
        bd.addBlock(reader);
        BeanBlock writer = new BeanBlock();
        writer.setName("writer");
        writer.setRuntimeClassName(LineWriterSink.class.getName());
        writer.setProperty("fileName", OUTPUT_FILE_NAME);
        bd.addBlock(writer);
        Connection c1 = new Connection(reader.getPortByName("outputPort"), writer.getPortByName("inputPort"));
        bd.addConnection(c1);
        return bd;
    }
}

