/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.data;

import java.util.Arrays;
import jp.hasc.hasctool.core.data.AbstractSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;

class ArrayVectorSignalMessage
extends AbstractSignalMessage
implements VectorSignalMessage {
    private double[] vectorValue_;

    public ArrayVectorSignalMessage(long time, double[] vectorValue, boolean cloneVectorValue) {
        super(time);
        if (cloneVectorValue) {
            vectorValue = (double[])vectorValue.clone();
        }
        this.vectorValue_ = vectorValue;
    }

    @Override
    public double getVectorElement(int index) {
        return this.vectorValue_[index];
    }

    @Override
    public double getVectorNorm() {
        double sum = 0.0;
        int i = 0;
        while (i < this.vectorValue_.length) {
            double element = this.vectorValue_[i];
            sum += element * element;
            ++i;
        }
        return Math.sqrt(sum);
    }

    @Override
    public int getVectorSize() {
        return this.vectorValue_.length;
    }

    @Override
    public SignalMessage createDelayedElement(long delay) {
        if (delay == 0L) {
            return this;
        }
        return new ArrayVectorSignalMessage(this.getTime() + delay, this.vectorValue_, false);
    }

    public String toString() {
        return "{time:" + this.getTime() + ", value:" + Arrays.toString(this.vectorValue_) + "}";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.vectorValue_);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayVectorSignalMessage other = (ArrayVectorSignalMessage)obj;
        return Arrays.equals(this.vectorValue_, other.vectorValue_);
    }
}

