/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.data;

import java.util.Arrays;
import jp.hasc.hasctool.core.data.AbstractSignalMessage;
import jp.hasc.hasctool.core.data.Complex;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;

public class ComplexVectorSignalMessage
extends AbstractSignalMessage
implements VectorSignalMessage {
    private Complex[] vectorValue_;

    public ComplexVectorSignalMessage(long time, Complex[] vectorValue, boolean cloneVectorValue) {
        super(time);
        if (cloneVectorValue) {
            vectorValue = (Complex[])vectorValue.clone();
        }
        this.vectorValue_ = vectorValue;
    }

    public Complex getVectorValue(int index) {
        return new Complex(this.vectorValue_[index].re(), this.vectorValue_[index].im());
    }

    @Override
    public double getVectorElement(int index) {
        return this.vectorValue_[index].abs();
    }

    @Override
    public double getVectorNorm() {
        double sum = 0.0;
        int i = 0;
        while (i < this.vectorValue_.length) {
            double element = this.vectorValue_[i].abs();
            sum += element * element;
            ++i;
        }
        return Math.sqrt(sum);
    }

    @Override
    public int getVectorSize() {
        return this.vectorValue_.length;
    }

    @Override
    public SignalMessage createDelayedElement(long delay) {
        if (delay == 0L) {
            return this;
        }
        return new ComplexVectorSignalMessage(this.getTime() + delay, this.vectorValue_, false);
    }

    public String toString() {
        return "{time:" + this.getTime() + ", value:" + Arrays.toString(this.vectorValue_) + "}";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.vectorValue_);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexVectorSignalMessage other = (ComplexVectorSignalMessage)obj;
        return Arrays.equals(this.vectorValue_, other.vectorValue_);
    }
}

