/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.data;

import jp.hasc.hasctool.core.data.AbstractSignalMessage;
import jp.hasc.hasctool.core.data.SignalMessage;
import jp.hasc.hasctool.core.data.VectorSignalMessage;

public class ScalarSignalMessage
extends AbstractSignalMessage
implements VectorSignalMessage {
    private double scalarValue_;

    public ScalarSignalMessage(long time, double scalarValue) {
        super(time);
        this.scalarValue_ = scalarValue;
    }

    public double getScalarValue() {
        return this.scalarValue_;
    }

    @Override
    public double getVectorElement(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.scalarValue_;
    }

    @Override
    public double getVectorNorm() {
        return Math.abs(this.scalarValue_);
    }

    @Override
    public int getVectorSize() {
        return 1;
    }

    @Override
    public SignalMessage createDelayedElement(long delay) {
        if (delay == 0L) {
            return this;
        }
        return new ScalarSignalMessage(this.getTime() + delay, this.scalarValue_);
    }

    public String toString() {
        return "{time:" + this.getTime() + ", value:" + this.scalarValue_ + "}";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.scalarValue_);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScalarSignalMessage other = (ScalarSignalMessage)obj;
        return Double.doubleToLongBits(this.scalarValue_) == Double.doubleToLongBits(other.scalarValue_);
    }
}

