/*
 * Decompiled with CFR 0.152.
 */
package jp.hasc.hasctool.core.runtime;

import java.util.concurrent.Callable;
import jp.hasc.hasctool.core.runtime.AbstractRuntimeBean;
import jp.hasc.hasctool.core.runtime.RuntimeContext;
import jp.hasc.hasctool.core.runtime.TaskManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTask
extends AbstractRuntimeBean
implements Callable<Object> {
    private static final Log LOG = LogFactory.getLog(AbstractTask.class);
    private boolean called_ = false;

    public TaskManager getTaskManager() {
        return this.getRuntimeContext().getTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        AbstractTask abstractTask = this;
        synchronized (abstractTask) {
            if (this.called_) {
                throw new IllegalStateException();
            }
            this.called_ = true;
        }
        try {
            this.run();
        }
        catch (InterruptedException ex) {
            LOG.warn((Object)("Task interrupted: " + this.toString()));
            LOG.warn((Object)"InterruptedException", (Throwable)ex);
        }
        catch (Throwable ex) {
            LOG.warn((Object)"Unhandled Exception", ex);
            this.getRuntimeContext().onCatchUnhandledException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDirect() throws InterruptedException {
        AbstractTask abstractTask = this;
        synchronized (abstractTask) {
            if (this.called_) {
                throw new IllegalStateException();
            }
            this.called_ = true;
        }
        this.getTaskManager().runDirect(this);
    }

    protected boolean isShutdown() {
        return this.getTaskManager().getExecutorService().isShutdown();
    }

    protected abstract void run() throws InterruptedException;

    @Override
    public void setup(RuntimeContext context) {
        super.setup(context);
        this.getTaskManager().register(this);
    }

    public void start() {
        this.getTaskManager().start(this);
    }
}

